/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.feed;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.function.BiPredicate;
import java.util.logging.Level;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EObject;
import net.sf.eBus.client.ESubscribeFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.feed.EPatternFeed;
import net.sf.eBus.feed.EventPattern;
import net.sf.eBus.feed.MatchEvent;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;

final class EOrderedPatternFeed
extends EPatternFeed {
    public static final int START_STATE_ID = 0;
    public static final int INITIAL_USER_STATE_ID = 1;
    public static final int FINAL_STATE_ID = -1;
    private static final Transition[] EMPTY_TRANSITIONS = new Transition[0];
    private static final Transition NO_TRANSITION = new Transition((t, u) -> false, -1, new String[0]);
    private Transition[][][] mNdFSM;
    private Queue<MatchFrame> mMatchFrames = new LinkedList<MatchFrame>();

    private EOrderedPatternFeed(EClient client, EventPattern pattern) {
        super(client, pattern);
    }

    @Override
    protected void matchEvent(ENotificationMessage event, int eventId) {
        LinkedList<MatchFrame> frames = new LinkedList<MatchFrame>();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: received event ID %d:%n%s", this.mPubKey, eventId, event));
        } else {
            sLogger.finer(String.format("%s: received %s event.", this.mPubKey, event.key()));
        }
        this.mMatchFrames.add(new MatchFrame(this.mPatternName, this.mIsExclusive));
        while (!this.mMatchFrames.isEmpty()) {
            MatchFrame currFrame = this.mMatchFrames.poll();
            if (currFrame.isDefunct() || !this.mUntil.test(currFrame.allEvents(), event)) continue;
            this.matchEvent(event, eventId, currFrame, frames);
        }
        this.mMatchFrames = frames;
    }

    protected static EOrderedPatternFeed openFeed(ESubscriber client, EventPattern pattern) {
        EClient eClient = EClient.findOrCreateClient((EObject)client, (EClient.ClientLocation)EClient.ClientLocation.LOCAL);
        EOrderedPatternFeed retval = new EOrderedPatternFeed(eClient, pattern);
        retval.setStateMachine(EOrderedPatternFeed.createFSM(pattern));
        retval.setSubscribeFeeds(pattern);
        return retval;
    }

    private void matchEvent(ENotificationMessage event, int eventId, MatchFrame mf, Queue<MatchFrame> frames) {
        int stateId = mf.currentState();
        Transition[] transitions = this.mNdFSM[stateId][eventId];
        int numTransitions = transitions.length;
        MatchFrame frame = mf;
        mf.incrementCount();
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s: %s event, # transitions=%d%n%s%nframe=%s", this.mPatternName, event.key(), numTransitions, event, mf));
        } else if (sLogger.isLoggable(Level.FINER)) {
            sLogger.finer(String.format("%s: %s event, # transitions=%d", this.mPatternName, event.key(), numTransitions));
        }
        for (int i = 0; i < numTransitions; ++i) {
            if (!transitions[i].matches(event, frame)) continue;
            int nextStateId = transitions[i].nextState();
            int matchCount = nextStateId != stateId ? 0 : mf.matchCount();
            frame = new MatchFrame(nextStateId, matchCount, mf);
            frame.addEvent(event, transitions[i].groups());
            if (this.mIsExclusive) {
                this.addMapping(event, frame);
            }
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s: new match frame: %s", this.mPubKey, frame));
            }
            if (nextStateId == -1) {
                MatchEvent me = frame.generateMatch(this.mPubKey.subject());
                if (!this.mCondition.test(me)) continue;
                EClient.dispatch((Runnable)new EFeed.NotifyTask((EFeed)this, (ENotificationMessage)me, NO_CONDITION, (IESubscribeFeed)this, this.mNotifyCallback), (EObject)this.mEClient.target());
                if (!this.mIsExclusive) continue;
                this.markDefunct(frame.allEvents());
                continue;
            }
            frames.add(frame);
        }
    }

    private void setSubscribeFeeds(EventPattern pattern) {
        Collection<EventPattern.FeedInfo> feeds = pattern.parameters().values();
        for (EventPattern.FeedInfo info : feeds) {
            ESubscribeFeed subFeed = ESubscribeFeed.open((ESubscriber)this, (EMessageKey)info.messageKey(), (EFeed.FeedScope)info.scope(), (ECondition)info.condition());
            int feedId = subFeed.feedId();
            this.mSubFeeds.add(subFeed);
            this.mAllSubFeedsMask |= 1L << feedId;
        }
    }

    private static Transition[][][] createFSM(EventPattern pattern) {
        Iterator<EventPattern.PatternComponent> pcIt = pattern.components().iterator();
        HashMap<Integer, Map<Integer, List<Transition>>> fsm = new HashMap<Integer, Map<Integer, List<Transition>>>();
        int numParams = pattern.parameters().size();
        int currState = 0;
        while (pcIt.hasNext()) {
            EventPattern.PatternComponent pc = pcIt.next();
            currState = EOrderedPatternFeed.createTransitions(currState, pc, EOrderedPatternFeed.initializeState(currState, numParams, fsm), !pcIt.hasNext());
        }
        return EOrderedPatternFeed.generateFSM(fsm, numParams);
    }

    private static int createTransitions(int currentState, EventPattern.PatternComponent pc, Map<Integer, List<Transition>> events, boolean isFinal) {
        int minMatchCount = pc.minimumMatchCount();
        int maxMatchCount = pc.maximumMatchCount();
        if (maxMatchCount > 1) {
            EOrderedPatternFeed.createTransition(TransitionType.MAXIMUM, currentState, minMatchCount, maxMatchCount, events, pc);
        }
        int nextState = isFinal ? -1 : currentState + 1;
        EOrderedPatternFeed.createTransition(TransitionType.MINIMUM, nextState, minMatchCount, maxMatchCount, events, pc);
        return nextState;
    }

    private static void createTransition(TransitionType tType, int nextState, int minMatchCount, int maxMatchCount, Map<Integer, List<Transition>> events, EventPattern.PatternComponent pc) {
        if (pc instanceof EventPattern.SinglePatternComponent) {
            EOrderedPatternFeed.createTransition(tType, nextState, minMatchCount, maxMatchCount, events, (EventPattern.SinglePatternComponent)pc);
        } else {
            EOrderedPatternFeed.createTransition(tType, nextState, minMatchCount, maxMatchCount, events, (EventPattern.MultiPatternComponent)pc);
        }
    }

    private static void createTransition(TransitionType tType, int nextState, int minMatchCount, int maxMatchCount, Map<Integer, List<Transition>> events, EventPattern.MultiPatternComponent mpc) {
        EventPattern.SinglePatternComponent[] subs = mpc.components();
        int numSubs = subs.length;
        for (int subIndex = 0; subIndex < numSubs; ++subIndex) {
            EOrderedPatternFeed.createTransition(tType, nextState, minMatchCount, maxMatchCount, events, subs[subIndex]);
        }
    }

    private static void createTransition(TransitionType tType, int nextState, int minMatchCount, int maxMatchCount, Map<Integer, List<Transition>> events, EventPattern.SinglePatternComponent spc) {
        Transition transition;
        int transId = spc.transitionIdentifier();
        List<Transition> transitions = events.get(transId);
        switch (tType) {
            case MAXIMUM: {
                transition = new Transition((e, g) -> EOrderedPatternFeed.componentTest(e, g, spc.condition()) && g.matchCount() < maxMatchCount, nextState, spc.groupNames());
                break;
            }
            default: {
                transition = new Transition((e, g) -> EOrderedPatternFeed.componentTest(e, g, spc.condition()) && g.matchCount() >= minMatchCount, nextState, spc.groupNames());
            }
        }
        transitions.add(transition);
    }

    private static Map<Integer, List<Transition>> initializeState(int stateId, int numTransitions, Map<Integer, Map<Integer, List<Transition>>> fsm) {
        HashMap<Integer, List<Transition>> retval = new HashMap<Integer, List<Transition>>(numTransitions);
        fsm.put(stateId, retval);
        for (int ti = 0; ti < numTransitions; ++ti) {
            ArrayList<Transition> transitions = new ArrayList<Transition>();
            retval.put(ti, transitions);
            transitions.add(NO_TRANSITION);
        }
        return retval;
    }

    private static Transition[][][] generateFSM(Map<Integer, Map<Integer, List<Transition>>> fsm, int numEvents) {
        Transition[][][] retval = new Transition[fsm.size()][][];
        for (Map.Entry<Integer, Map<Integer, List<Transition>>> state : fsm.entrySet()) {
            int si = state.getKey();
            Map<Integer, List<Transition>> events = state.getValue();
            retval[si] = new Transition[numEvents][];
            for (int ei = 0; ei < numEvents; ++ei) {
                retval[si][ei] = !events.containsKey(ei) ? EMPTY_TRANSITIONS : events.get(ei).toArray(EMPTY_TRANSITIONS);
            }
        }
        return retval;
    }

    private void setStateMachine(Transition[][][] ndFsm) {
        this.mNdFSM = ndFsm;
    }

    private static enum TransitionType {
        MAXIMUM,
        MINIMUM;

    }

    private static final class MatchFrame
    extends EPatternFeed.AbstractMatchFrame {
        private final int mStateId;
        private final Map<String, List<ENotificationMessage>> mGroups;
        private int mMatchCount;

        private MatchFrame(String patternName, boolean isExclusive) {
            super(patternName, isExclusive);
            this.mStateId = 0;
            this.mMatchCount = 0;
            this.mGroups = new HashMap<String, List<ENotificationMessage>>();
            this.mGroups.put("__ALL_EVENTS__", this.mAllEvents);
        }

        private MatchFrame(int stateId, int matchCount, MatchFrame frame) {
            super(frame);
            this.mStateId = stateId;
            this.mMatchCount = matchCount;
            this.mGroups = new HashMap<String, List<ENotificationMessage>>();
            for (Map.Entry<String, List<ENotificationMessage>> entry : frame.mGroups.entrySet()) {
                String key = entry.getKey();
                if ("__ALL_EVENTS__".equals(key)) continue;
                this.mGroups.put(key, new ArrayList(entry.getValue()));
            }
            this.mGroups.put("__ALL_EVENTS__", this.mAllEvents);
        }

        @Override
        protected Map<String, List<ENotificationMessage>> groupMap() {
            HashMap retval = new HashMap(this.mGroups.size());
            this.mGroups.entrySet().forEach(entry -> retval.put(entry.getKey(), Collections.unmodifiableList((List)entry.getValue())));
            return Collections.unmodifiableMap(retval);
        }

        @Override
        public String toString() {
            return String.format("%s%n[match count=%d, state=%d]", super.toString(), this.mMatchCount, this.mStateId);
        }

        public int currentState() {
            return this.mStateId;
        }

        public int matchCount() {
            return this.mMatchCount;
        }

        public MatchEvent generateMatch(String subject) {
            this.mGroups.keySet().forEach(group -> this.mGroups.put((String)group, Collections.unmodifiableList(this.mGroups.get(group))));
            return new MatchEvent(subject, this.groupMap(), this.userCache());
        }

        public void incrementCount() {
            ++this.mMatchCount;
        }

        public void addEvent(ENotificationMessage event, String[] groups) {
            int numGroups = groups.length;
            for (int i = 0; i < numGroups; ++i) {
                this.getGroup(groups[i]).add(event);
            }
        }

        private List<ENotificationMessage> getGroup(String groupName) {
            ArrayList<ENotificationMessage> retval;
            if (this.mGroups.containsKey(groupName)) {
                retval = this.mGroups.get(groupName);
            } else {
                retval = new ArrayList();
                this.mGroups.put(groupName, retval);
            }
            return retval;
        }
    }

    private static final class Transition {
        private final BiPredicate<ENotificationMessage, MatchFrame> mCondition;
        private final int mNextState;
        private final String[] mGroups;

        private Transition(BiPredicate<ENotificationMessage, MatchFrame> guard, int nextState, String[] groups) {
            this.mCondition = guard;
            this.mNextState = nextState;
            this.mGroups = groups;
        }

        public boolean matches(ENotificationMessage event, MatchFrame frame) {
            return this.mCondition.test(event, frame);
        }

        public int nextState() {
            return this.mNextState;
        }

        private String[] groups() {
            return this.mGroups;
        }
    }
}

