/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ZonedDateTimeType
extends DataType {
    ZonedDateTimeType() {
        super(ZonedDateTime.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof ZonedDateTime) {
            ZonedDateTime zdt = (ZonedDateTime)o;
            buffer.putLong(zdt.toLocalDate().toEpochDay()).putLong(zdt.toLocalTime().toNanoOfDay());
            STRING_TYPE.serialize(zdt.getZone().getId(), buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        LocalDate ld = LocalDate.ofEpochDay(buffer.getLong());
        LocalTime lt = LocalTime.ofNanoOfDay(buffer.getLong());
        ZoneId zoneId = ZoneId.of((String)STRING_TYPE.deserialize(buffer));
        return ZonedDateTime.of(ld, lt, zoneId);
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong((%s.toLocalDate()).toEpochDay())%n", indent, fieldName);
        output.format("%s      .putLong((%s.toLocalTime()).toNanoOfDay());%n", indent, fieldName);
        STRING_TYPE.createSerializer(field, String.format("(((%s).getZone()).getId())", fieldName), indent, output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.ZonedDateTime.of(ld, lt, java.time.ZoneId.of(s)));%n" : "%s%s = java.time.ZonedDateTime.of(ld, lt, java.time.ZoneId.of(s));%n";
        output.format("%sfinal java.time.LocalDate ld = java.time.LocalDate.ofEpochDay(buffer.getLong());%n", indent).format("%sfinal java.time.LocalTime lt = java.time.LocalTime.ofNanoOfDay(buffer.getLong());%n", indent).format("%sfinal String s;%n%n", indent);
        STRING_TYPE.createDeserializer(field, "s", indent, output, false);
        output.format(format, indent, fieldName);
    }
}

