/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.ZoneOffset;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ZoneOffsetType
extends DataType {
    public static final int BYTES = 8;

    ZoneOffsetType() {
        super(ZoneOffset.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof ZoneOffset) {
            buffer.putLong(((ZoneOffset)o).getTotalSeconds());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return ZoneOffset.ofTotalSeconds(buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putInt(%s.getTotalSeconds());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.ZoneOffset.ofTotalSeconds(buffer.getInt()));%n" : "%s%s = java.time.ZoneOffset.ofTotalSeconds(buffer.getInt());%n";
        output.format(format, indent, fieldName);
    }
}

