/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ZoneIdType
extends DataType {
    ZoneIdType() {
        super(ZoneId.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof ZoneId) {
            STRING_TYPE.serialize(((ZoneId)o).getId(), buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return ZoneId.of((String)STRING_TYPE.deserialize(buffer));
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        STRING_TYPE.createSerializer(field, String.format("((%s).getId())", fieldName), indent, output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.ZoneId.of(s));%n" : "%s%s = java.time.ZoneId.of(s);%n";
        output.format("%sfinal String s;%n", indent);
        STRING_TYPE.createDeserializer(field, "s", indent, output, false);
        output.format(format, indent, fieldName);
    }
}

