/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.Year;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class YearType
extends DataType {
    public static final int BYTES = 4;

    YearType() {
        super(Year.class, true, 4, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Year) {
            buffer.putInt(((Year)o).getValue());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return Year.of(buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putInt(%s.getValue());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.Year.of(buffer.getInt()));%n" : "%s%s = java.time.Year.of(buffer.getInt());%n";
        output.format(format, indent, fieldName);
    }
}

