/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.YearMonth;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class YearMonthType
extends DataType {
    public static final int BYTES = 8;

    YearMonthType() {
        super(YearMonth.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof YearMonth) {
            YearMonth ym = (YearMonth)o;
            buffer.putInt(ym.getYear()).putInt(ym.getMonthValue());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return YearMonth.of(buffer.getInt(), buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%1$sbuffer.putInt(%2$s.getYear())%n%1$s      .putInt(%2$s.getMonthValue());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.YearMonth.of(buffer.getInt(), buffer.getInt()));%n" : "%s%s = java.time.YearMonth.of(buffer.getInt(), buffer.getInt());%n";
        output.format(format, indent, fieldName);
    }
}

