/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.net.URI;
import java.net.URISyntaxException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class UriType
extends DataType {
    UriType() {
        super(URI.class, false, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof URI) {
            STRING_TYPE.serialize(o.toString(), buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        String s = (String)STRING_TYPE.deserialize(buffer);
        URI retval = null;
        if (!s.isEmpty()) {
            try {
                retval = new URI(s);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal String s = (%s).toString();%n", indent, fieldName);
        STRING_TYPE.createSerializer(field, "s", indent, output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String indent2 = indent1 + "  ";
        String format0 = useBuilder ? "%sbuilder.%s(new java.net.URI(s));%n" : "%s%s = new java.net.URI(s);%n";
        String format1 = useBuilder ? "%sbuilder.%s(null);%n" : "%s%s = null;%n";
        output.format("%sfinal String s;%n", indent);
        STRING_TYPE.createDeserializer(field, "s", indent, output, false);
        output.format("%sif (s.isEmpty()) {%n", indent).format(useBuilder ? "%sbuilder.%s(null);%n" : "%s%s = null;%n", indent1, fieldName).format("%s} else {%n", indent).format("%stry {%n", indent1).format(format0, indent2, fieldName).format("%s} catch (java.net.URISyntaxException synex) {%n", indent1).format(format1, indent2, fieldName).format("%s}%n", indent1).format("%s}%n", indent);
    }
}

