/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class StringType
extends DataType {
    StringType() {
        super(String.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof String) {
            this.serialize((String)o, 1024, buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        short size = buffer.getShort();
        String retval = "";
        if (size > 0) {
            byte[] b = new byte[size];
            buffer.get(b, 0, size);
            retval = new String(b, CHARSET);
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        this.createSerializer(field, fieldName, indent, "MAX_STRING_LENGTH", output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String format = useBuilder ? "%sbuilder.%s(new String(b, charset));%n" : "%s%s = new String(b, charset);%n";
        output.format("%sfinal java.nio.charset.Charset charset = net.sf.eBus.messages.type.DataType.findCharset(\"%s\");%n", indent, field.charset()).format("%sfinal int stringSize = buffer.getShort();%n%n", indent).format("%sif (stringSize == 0) {%n", indent).format(useBuilder ? "%sbuilder.%s(EMPTY_STRING);%n" : "%s%s = EMPTY_STRING;%n", indent1, fieldName).format("%s} else {%n", indent).format("%sfinal byte[] b = new byte[stringSize];%n", indent1).format("%sbuffer.get(b, 0, stringSize);%n", indent1).format(format, indent1, fieldName).format("%s}%n", indent);
    }

    void serialize(String s, int maxSize, ByteBuffer buffer) throws BufferOverflowException {
        int length = s.length();
        if (length > maxSize) {
            BufferOverflowException bufex = new BufferOverflowException();
            bufex.initCause(new IllegalArgumentException(String.format("string length %,d exceeds allowed maximum %,d", length, maxSize)));
            throw bufex;
        }
        if (length == 0) {
            buffer.putShort((short)0);
        } else {
            byte[] b = s.getBytes(CHARSET);
            buffer.putShort((short)b.length).put(b);
        }
    }

    void createSerializer(MessageType.MessageField field, String fieldName, String indent, String maxConst, Formatter output) {
        String indent1 = indent + "  ";
        output.format("%sjava.nio.charset.Charset charset = net.sf.eBus.messages.type.DataType.findCharset(\"%s\");%n", indent, field.charset()).format("%sfinal int length = (%s).length();%n%n", indent, fieldName).format("%sif (length > %s) {%n", indent, maxConst).format("%sjava.nio.BufferOverflowException bufex = new java.nio.BufferOverflowException();%n", indent1).format("%sbufex.initCause(new IllegalArgumentException(\"string length exceeds %s\"));%n", indent1, maxConst).format("%sthrow (bufex);%n", indent1).format("%s} else if (length == 0) {%n", indent).format("%sbuffer.putShort((short) 0);%n", indent1).format("%s} else {%n", indent).format("%sfinal byte[] b = %s.getBytes(charset);%n", indent1, fieldName);
        output.format("%sbuffer.putShort((short) b.length)%n", indent1);
        output.format("%s      .put(b);%n", indent1);
        output.format("%s}%n", indent);
    }
}

