/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.Period;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class PeriodType
extends DataType {
    public static final int BYTES = 12;

    PeriodType() {
        super(Period.class, true, 12, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Period) {
            Period p = (Period)o;
            buffer.putInt(p.getYears()).putInt(p.getMonths()).putInt(p.getDays());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return Period.of(buffer.getInt(), buffer.getInt(), buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%1$sbuffer.putInt(%2$s.getYears())%n%1$s      .putInt(%2$s.getMonths())%n%1$s      .putInt(%2$s.getDays());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.Period.of(buffer.getInt(), buffer.getInt(), buffer.getInt()));%n" : "%s%s = java.time.Period.of(buffer.getInt(), buffer.getInt(), buffer.getInt());%n";
        output.format(format, indent, fieldName);
    }
}

