/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class OffsetTimeType
extends DataType {
    public static final int BYTES = 12;

    public OffsetTimeType() {
        super(OffsetTime.class, true, 12, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof OffsetTime) {
            OffsetTime ot = (OffsetTime)o;
            buffer.putLong(ot.toLocalTime().toNanoOfDay()).putInt(ot.getOffset().getTotalSeconds());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return OffsetTime.of(LocalTime.ofNanoOfDay(buffer.getLong()), ZoneOffset.ofTotalSeconds(buffer.getInt()));
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong((%s.toLocalTime()).toNanoOfDay())%n", indent, fieldName);
        output.format("%s      .putInt((%s.getOffset()).getTotalSeconds());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.OffsetTime.of(java.time.LocalTime.ofNanoOfDay(buffer.getLong()), java.time.ZoneOffset.ofTotalSeconds(buffer.getInt())));%n" : "%s%s = java.time.OffsetTime.of(java.time.LocalTime.ofNanoOfDay(buffer.getLong()), java.time.ZoneOffset.ofTotalSeconds(buffer.getInt()));%n";
        output.format(format, indent, fieldName);
    }
}

