/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class OffsetDateTimeType
extends DataType {
    public static final int BYTES = 20;

    OffsetDateTimeType() {
        super(OffsetDateTime.class, true, 20, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof OffsetDateTime) {
            OffsetDateTime odt = (OffsetDateTime)o;
            buffer.putLong(odt.toLocalDate().toEpochDay()).putLong(odt.toLocalTime().toNanoOfDay()).putInt(odt.getOffset().getTotalSeconds());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return OffsetDateTime.of(LocalDate.ofEpochDay(buffer.getLong()), LocalTime.ofNanoOfDay(buffer.getLong()), ZoneOffset.ofTotalSeconds(buffer.getInt()));
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong((%s.toLocalDate()).toEpochDay())%n", indent, fieldName);
        output.format("%s      .putLong((%s.toLocalTime()).toNanoOfDay())%n", indent, fieldName);
        output.format("%s      .putInt((%s.getOffset()).getTotalSeconds());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.OffsetDateTime.of(java.time.LocalDate.ofEpochDay(buffer.getLong()), java.time.LocalTime.ofNanoOfDay(buffer.getLong()), java.time.ZoneOffset.ofTotalSeconds(buffer.getInt())));%n" : "%s%s = java.time.OffsetDateTime.of(java.time.LocalDate.ofEpochDay(buffer.getLong()), java.time.LocalTime.ofNanoOfDay(buffer.getLong()), java.time.ZoneOffset.ofTotalSeconds(buffer.getInt()));%n";
        output.format(format, indent, fieldName);
    }
}

