/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.MonthDay;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class MonthDayType
extends DataType {
    public static final int BYTES = 8;

    MonthDayType() {
        super(MonthDay.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof MonthDay) {
            MonthDay md = (MonthDay)o;
            buffer.putInt(md.getMonthValue()).putInt(md.getDayOfMonth());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return MonthDay.of(buffer.getInt(), buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%1$sbuffer.putInt(%2$s.getMonthValue()).putInt(%2$s.getDayOfMonth());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.MonthDay.of(buffer.getInt(), buffer.getInt()));%n" : "%s%s = java.time.MonthDay.of(buffer.getInt(), buffer.getInt());%n";
        output.format(format, indent, fieldName);
    }
}

