/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import com.google.common.base.Strings;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.sf.eBus.messages.ELocalOnly;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.EReplyInfo;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.EStringInfo;
import net.sf.eBus.messages.InvalidMessageException;
import net.sf.eBus.messages.UnknownMessageException;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.ArrayType;
import net.sf.eBus.messages.type.DataType;

public abstract class MessageType
extends DataType {
    public static final String BUILDER_METHOD = "builder";
    public static final String BUILD_INNER_CLASS = "Builder";
    public static final int PUBLIC_STATIC = 9;
    public static final int PUBLIC_FINAL = 17;
    public static final String SUBJECT_FIELD = "subject";
    private static final Comparator<MessageField> sNameComparator = (f0, f1) -> f0.name().compareTo(f1.name());
    private static final Comparator<MessageField> sSizeComparator = (f0, f1) -> {
        DataType d0 = f0.dataType();
        DataType d1 = f1.dataType();
        int d0Size = d0.size();
        int d1Size = d1.size();
        int retval = d0Size == Integer.MAX_VALUE ? 1 : (d1Size == Integer.MAX_VALUE ? -1 : d1Size - d0Size);
        return retval;
    };
    protected final List<MessageField> mFields;
    protected final List<Class<? extends EReplyMessage>> mReplyClasses;
    protected String mSubject;

    protected MessageType(Class<?> clazz, List<MessageField> fields, List<Class<? extends EReplyMessage>> replies) {
        super(clazz, false, Integer.MAX_VALUE, null);
        this.mFields = fields;
        this.mReplyClasses = replies;
        this.mSubject = null;
    }

    public boolean isValidReply(Class<?> clazz) {
        Iterator<Class<? extends EReplyMessage>> cit = this.mReplyClasses.iterator();
        boolean retcode = false;
        while (cit.hasNext() && !retcode) {
            retcode = clazz.equals(cit.next());
        }
        return retcode;
    }

    public List<Class<? extends EReplyMessage>> replyTypes() {
        return this.mReplyClasses;
    }

    public List<Object> values(EMessageObject message) throws Throwable {
        ArrayList<Object> retval = new ArrayList<Object>(this.mFields.size());
        for (MessageField field : this.mFields) {
            retval.add(field.field().invokeWithArguments(message));
        }
        return retval;
    }

    public int numberFields() {
        return this.mFields.size();
    }

    public List<MessageField> fields() {
        return this.mFields;
    }

    public void subject(String subject) throws IllegalArgumentException {
        if (Strings.isNullOrEmpty((String)subject)) {
            throw new IllegalArgumentException("subject is null or empty");
        }
        this.mSubject = subject;
    }

    protected int serializeFields(Object o, ByteBuffer buffer) throws BufferOverflowException {
        return 0;
    }

    protected Object deserializeFields(int fieldMask, ByteBuffer buffer) throws BufferUnderflowException, UnknownMessageException, ValidationException {
        return null;
    }

    protected static List<MessageField> findFields(Class<? extends EMessageObject> mc) {
        boolean messageFlag = EMessage.class.isAssignableFrom(mc);
        Field[] fields = mc.getFields();
        int numFields = fields.length;
        boolean localFlag = mc.isAnnotationPresent(ELocalOnly.class);
        ArrayList<MessageField> retval = new ArrayList<MessageField>();
        for (int index = 0; index < numFields; ++index) {
            int modifiers = fields[index].getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            if (!Modifier.isFinal(modifiers)) {
                throw new InvalidMessageException(mc, mc.getCanonicalName() + "." + fields[index].getName() + " is public but not final");
            }
            if (messageFlag && SUBJECT_FIELD.equals(fields[index].getName())) continue;
            retval.add(MessageType.loadField(index, fields[index], mc));
        }
        if (!localFlag) {
            MessageType.validateFields(mc, retval);
            retval.sort(sNameComparator);
            retval.sort(sSizeComparator);
        }
        return retval;
    }

    static void replyClasses(Class<? extends EMessageObject> mc, List<Class<? extends EReplyMessage>> classes) throws InvalidMessageException {
        Class<? extends EMessageObject> parent = mc.getSuperclass();
        if (!mc.isAnnotationPresent(EReplyInfo.class)) {
            throw new InvalidMessageException(mc, String.format("%s missing @EReplyInfo annotation", mc.getName()));
        }
        EReplyInfo replyInfo = mc.getAnnotation(EReplyInfo.class);
        if (parent != null && !parent.equals(EMessage.class)) {
            MessageType.replyClasses(parent, classes);
        }
        classes.addAll(Arrays.asList(replyInfo.replyMessageClasses()));
    }

    private static MessageField loadField(int index, Field field, Class<? extends EMessageObject> mc) throws InvalidMessageException {
        MethodHandle fh;
        DataType dataType;
        boolean optFlag;
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        Class<?> jType = field.getType();
        String name = field.getName();
        String charset = MessageType.getCharset(field);
        try {
            optFlag = jType.isAnnotationPresent(Nullable.class);
            dataType = DataType.findType(jType);
            fh = lookup.findGetter(mc, name, jType);
        }
        catch (IllegalArgumentException | NullPointerException argex) {
            throw new InvalidMessageException(mc, String.format("%s.%s invalid type %s", mc.getName(), name, jType == null ? "(no type)" : jType.getName()), argex);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException jex) {
            throw new InvalidMessageException(mc, String.format("%s has no field \"%s\"", mc.getName(), name), jex);
        }
        return new MessageField(index, name, fh, dataType, charset, optFlag);
    }

    private static String getCharset(Field field) {
        String retval;
        if (!String.class.equals(field.getType()) || !field.isAnnotationPresent(EStringInfo.class)) {
            retval = CHARSET.name();
        } else {
            EStringInfo sInfo = field.getAnnotation(EStringInfo.class);
            retval = sInfo.charset();
        }
        return retval;
    }

    private static void validateFields(Class<? extends EMessageObject> mc, List<MessageField> fields) {
        if (fields.size() > 31) {
            throw new InvalidMessageException(mc, String.format("%,d fields exceeds max allowed %,d", fields.size(), 31));
        }
        fields.stream().filter(field -> field.javaType().isAnnotationPresent(ELocalOnly.class)).forEachOrdered(field -> {
            throw new InvalidMessageException(mc, String.format("%s field is local-only", field.name()));
        });
    }

    public static final class MessageField {
        private final int mIndex;
        private final String mName;
        private final MethodHandle mField;
        private final DataType mDataType;
        private final String mCharset;
        private final boolean mIsOptional;
        private MethodHandle mSetter;

        public MessageField(int index, String name, MethodHandle field, DataType eType, String charset, boolean optFlag) {
            this.mIndex = index;
            this.mName = name;
            this.mField = field;
            this.mDataType = eType;
            this.mCharset = charset;
            this.mIsOptional = optFlag;
        }

        public boolean equals(Object o) {
            boolean retcode;
            boolean bl = retcode = this == o;
            if (!retcode && o instanceof MessageField) {
                retcode = this.mIndex == ((MessageField)o).mIndex;
            }
            return retcode;
        }

        public int hashCode() {
            return this.mIndex;
        }

        public String toString() {
            return String.format("[%,d] %s %s", this.mIndex, this.mName, this.mDataType);
        }

        public int index() {
            return this.mIndex;
        }

        public String name() {
            return this.mName;
        }

        public MethodHandle field() {
            return this.mField;
        }

        public Class<?> javaType() {
            return this.mDataType.dataClass();
        }

        public DataType dataType() {
            return this.mDataType;
        }

        public boolean isArray() {
            return this.mDataType instanceof ArrayType;
        }

        public String charset() {
            return this.mCharset;
        }

        public boolean isOptional() {
            return this.mIsOptional;
        }

        public MethodHandle setter() {
            return this.mSetter;
        }

        void setter(MethodHandle setter) {
            this.mSetter = setter;
        }
    }
}

