/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EMessageList;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class MessageListType
extends DataType {
    MessageListType() {
        super(EMessageList.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o != null) {
            EMessageList ml = (EMessageList)o;
            EMessageKey key = ml.key();
            MessageType mt = (MessageType)DataType.findType(key.messageClass());
            buffer.putShort((short)ml.size());
            KEY_TYPE.serialize(key, buffer);
            ml.forEach(msg -> mt.serialize(msg, buffer));
            ml.setReadOnly();
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        int size = buffer.getShort();
        EMessageKey key = (EMessageKey)KEY_TYPE.deserialize(buffer);
        String subject = key.subject();
        EMessageList<EMessage> retval = null;
        if (size < 0) {
            BufferUnderflowException bufex = new BufferUnderflowException();
            bufex.initCause(new IllegalArgumentException("invalid message list size " + size));
            throw bufex;
        }
        if (size == 0) {
            retval = new EMessageList<EMessage>(key);
        } else {
            MessageType mt = (MessageType)DataType.findType(key.messageClass());
            retval = new EMessageList(size, key);
            for (int index = 0; index < size; ++index) {
                mt.subject(subject);
                retval.add((EMessage)mt.deserialize(buffer));
            }
        }
        retval.setReadOnly();
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%s(net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EMessageList.class)).serialize(%s, buffer);%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s((%s) ((net.sf.eBus.messages.type.MessageListType) net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EMessageList.class)).deserialize(buffer));%n" : "%s%s = (%s) ((net.sf.eBus.messages.type.MessageListType) net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EMessageList.class)).deserialize(buffer);%n";
        output.format(format, indent, fieldName, this.mClass.getName());
    }
}

