/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class MessageKeyType
extends DataType {
    MessageKeyType() {
        super(EMessageKey.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof EMessageKey) {
            EMessageKey key = (EMessageKey)o;
            CLASS_TYPE.serialize(key.messageClass(), buffer);
            STRING_TYPE.serialize(key.subject(), buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return new EMessageKey((Class)CLASS_TYPE.deserialize(buffer), (String)STRING_TYPE.deserialize(buffer));
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal Class _mc = (%s).messageClass();%n", indent, fieldName);
        output.format("%sfinal String _subject = (%s).subject();%n", indent, fieldName);
        output.format("%s{%n", indent);
        CLASS_TYPE.createSerializer(field, "_mc", indent + "  ", output);
        output.format("%s}%n", indent);
        output.format("%s{%n", indent);
        STRING_TYPE.createSerializer(field, "_subject", indent + "  ", output);
        output.format("%s}%n", indent);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(new net.sf.eBus.messages.EMessageKey(_mc, _subject));%n" : "%s%s = new net.sf.eBus.messages.EMessageKey(_mc, _subject);%n";
        output.format("%sClass _mc = null;%n", indent).format("%sString _subject = null;%n", indent).format("%s{%n", indent);
        CLASS_TYPE.createDeserializer(field, "_mc", indent + "  ", output, false);
        output.format("%s}%n", indent).format("%s{%n", indent);
        STRING_TYPE.createDeserializer(field, "_subject", indent + "  ", output, false);
        output.format("%s}%n", indent).format(format, indent, fieldName);
    }
}

