/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.MessageType;

public final class LocalMessageType
extends MessageType {
    private LocalMessageType(Class<?> mc, List<Class<? extends EReplyMessage>> replies) {
        super(mc, Collections.emptyList(), replies);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        throw new UnsupportedOperationException("local only objects cannot be serialized");
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException, ValidationException {
        throw new UnsupportedOperationException("local only objects cannot be de-serialized");
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        throw new UnsupportedOperationException("local only objects cannot be serialized");
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        throw new UnsupportedOperationException("local only objects cannot be de-serialized");
    }

    static LocalMessageType createLocalMessageType(Class<? extends EMessageObject> mc) {
        ArrayList<Class<? extends EReplyMessage>> replyClasses = new ArrayList<Class<? extends EReplyMessage>>();
        if (ERequestMessage.class.isAssignableFrom(mc)) {
            LocalMessageType.replyClasses(mc, replyClasses);
        }
        return new LocalMessageType(mc, Collections.unmodifiableList(replyClasses));
    }
}

