/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class LocalDateType
extends DataType {
    public static final int BYTES = 8;

    public LocalDateType() {
        super(LocalDate.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof LocalDate) {
            buffer.putLong(((ChronoLocalDate)o).toEpochDay());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return LocalDate.ofEpochDay(buffer.getLong());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong(%s.toEpochDay());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.LocalDate.ofEpochDay(buffer.getLong()));%n" : "%sbuilder.%s(java.time.LocalDate.ofEpochDay(buffer.getLong()));%n";
        output.format(format, indent, fieldName);
    }
}

