/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class LocalDateTimeType
extends DataType {
    public static final int BYTES = 16;

    LocalDateTimeType() {
        super(LocalDateTime.class, true, 16, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)o;
            buffer.putLong(ldt.toLocalDate().toEpochDay()).putLong(ldt.toLocalTime().toNanoOfDay());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return LocalDateTime.of(LocalDate.ofEpochDay(buffer.getLong()), LocalTime.ofNanoOfDay(buffer.getLong()));
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong((%s.toLocalDate()).toEpochDay());%n", indent, fieldName);
        output.format("%sbuffer.putLong((%s.toLocalTime()).toNanoOfDay());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.LocalDateTime.of(java.time.LocalDate.ofEpochDay(buffer.getLong()), java.time.LocalTime.ofNanoOfDay(buffer.getLong())));%n" : "%s%s = java.time.LocalDateTime.of(java.time.LocalDate.ofEpochDay(buffer.getLong()), java.time.LocalTime.ofNanoOfDay(buffer.getLong()));%n";
        output.format(format, indent, fieldName);
    }
}

