/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class InstantType
extends DataType {
    public static final int BYTES = 8;

    InstantType() {
        super(Instant.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Instant) {
            buffer.putLong(((Instant)o).toEpochMilli());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return Instant.ofEpochMilli(buffer.getLong());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong(%s.toEpochMilli());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.time.Instant.ofEpochMilli(buffer.getLong()));%n" : "%s%s = java.time.Instant.ofEpochMilli(buffer.getLong());%n";
        output.format(format, indent, fieldName);
    }
}

