/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class InetSocketAddressType
extends DataType {
    InetSocketAddressType() {
        super(InetSocketAddress.class, true, Integer.MAX_VALUE, true);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)o;
            ADDRESS_TYPE.serialize(address.getAddress(), buffer);
            buffer.putInt(address.getPort());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        InetAddress addr = (InetAddress)ADDRESS_TYPE.deserialize(buffer);
        int port = buffer.getInt();
        return new InetSocketAddress(addr, port);
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal java.net.InetAddress addr = (%s).getAddress();%n", indent, fieldName);
        output.format("%sfinal int port = (%s).getPort();%n", indent, fieldName);
        ADDRESS_TYPE.createSerializer(field, "addr", indent, output);
        output.format("%sbuffer.putInt(port);%n", indent);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(new java.net.InetSocketAddress(_addr, _port));%n" : "%s%s = new java.net.InetSocketAddress(_addr, _port);%n";
        output.format("%sjava.net.InetAddress _addr = null;%n", indent).format("%sfinal int _port;%n", indent);
        ADDRESS_TYPE.createDeserializer(field, "_addr", indent, output, false);
        output.format("%s_port = buffer.getInt();%n", indent).format(format, indent, fieldName);
    }
}

