/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class InetAddressType
extends DataType {
    InetAddressType() {
        super(InetAddress.class, true, Integer.MAX_VALUE, true);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof InetAddress) {
            byte[] addr = ((InetAddress)o).getAddress();
            buffer.put((byte)addr.length).put(addr);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        byte addrSize = buffer.get();
        byte[] addr = new byte[addrSize];
        InetAddress retval = null;
        buffer.get(addr);
        try {
            retval = InetAddress.getByAddress(addr);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal byte[] a = (%s).getAddress();%n", indent, fieldName);
        output.format("%sbuffer.put((byte) a.length).put(a);%n", indent);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String format = useBuilder ? "%sbuilder.%s(java.net.InetAddress.getByAddress(_a));%n" : "%s%s = java.net.InetAddress.getByAddress(_a);%n";
        output.format("%sfinal int _addrSize = (int) buffer.get();%n", indent).format("%sfinal byte[] _a = new byte[_addrSize];%n%n", indent).format("%sbuffer.get(_a, 0, _addrSize);%n", indent).format("%stry {%n", indent).format(format, indent1, fieldName).format("%s} catch (Exception jex) {}%n", indent);
    }
}

