/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.io.File;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class FileType
extends DataType {
    FileType() {
        super(File.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof File) {
            STRING_TYPE.serialize(((File)o).getPath(), 1024, buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        String s = (String)STRING_TYPE.deserialize(buffer);
        File retval = null;
        if (!s.isEmpty()) {
            retval = new File(s);
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal String s = (%s).getPath();%n", indent, fieldName);
        STRING_TYPE.createSerializer(field, "s", indent, "MAX_FILE_NAME_LENGTH", output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String format = useBuilder ? "%sbuilder.%s(new java.io.File(s));%n" : "%s%s = new java.io.File(s);%n";
        output.format("%sfinal String s;%n", indent);
        STRING_TYPE.createDeserializer(field, "s", indent, output, false);
        output.format("%sif (s.isEmpty()) {%n", indent).format("%sbuilder.%s(null);%n", indent1, fieldName).format("%s} else {%n", indent).format(format, indent1, fieldName).format("%s}%n", indent);
    }
}

