/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.EField;
import net.sf.eBus.messages.EFieldList;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class FieldListType
extends DataType {
    FieldListType() {
        super(EFieldList.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o != null) {
            EFieldList fl = (EFieldList)o;
            if (fl.isEmpty()) {
                buffer.putShort((short)0);
            } else {
                Class fc = fl.elementClass();
                DataType dt = DataType.findType(fc);
                buffer.putShort((short)fl.size());
                CLASS_TYPE.serialize(fc, buffer);
                fl.forEach(field -> dt.serialize(field, buffer));
            }
            fl.setReadOnly();
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        int size = buffer.getShort();
        EFieldList<EField> retval = new EFieldList<EField>();
        if (size < 0) {
            BufferUnderflowException bufex = new BufferUnderflowException();
            bufex.initCause(new IllegalArgumentException("invalid field list size " + size));
            throw bufex;
        }
        if (size > 0) {
            Class fc = (Class)CLASS_TYPE.deserialize(buffer);
            DataType dt = DataType.findType(fc);
            for (int index = 0; index < size; ++index) {
                retval.add((EField)dt.deserialize(buffer));
            }
        }
        retval.setReadOnly();
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%s(net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EFieldList.class)).serialize(%s, buffer);%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s((%s) ((net.sf.eBus.messages.type.FieldListType) net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EFieldList.class)).deserialize(buffer));%n" : "%s%s = (%s) ((net.sf.eBus.messages.type.FieldListType) net.sf.eBus.messages.type.DataType.findType(net.sf.eBus.messages.EFieldList.class)).deserialize(buffer);%n";
        output.format(format, indent, fieldName, this.mClass.getName());
    }
}

