/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class EnumType
extends DataType {
    public static final int BYTES = 2;

    EnumType(Class<?> clazz) {
        super(clazz, true, 2, null);
    }

    @Override
    public boolean isInstance(Object o) {
        return o == null || this.mClass.isInstance(o);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Enum) {
            buffer.putShort((short)((Enum)o).ordinal());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        short ordinal = buffer.getShort();
        return this.mClass.getEnumConstants()[ordinal];
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putShort((short) (%s).ordinal());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s((%s.values())[(int) buffer.getShort()]);%n" : "%s%s = (%s.values())[(int) buffer.getShort()];%n";
        output.format(format, indent, fieldName, this.mClass.getCanonicalName());
    }
}

