/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class DateType
extends DataType {
    public static final int BYTES = 8;

    DateType() {
        super(Date.class, true, 8, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Date) {
            buffer.putLong(((Date)o).getTime());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return new Date(buffer.getLong());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong((%s).getTime());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(new java.util.Date(buffer.getLong()));%n" : "%s%s = new java.util.Date(buffer.getLong());%n";
        output.format(format, indent, fieldName);
    }
}

