/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.io.File;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtNewConstructor;
import javassist.CtNewMethod;
import javassist.NotFoundException;
import net.sf.eBus.messages.EFieldList;
import net.sf.eBus.messages.ELocalOnly;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EMessageList;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.InvalidMessageException;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.AbstractMessageType;
import net.sf.eBus.messages.type.ArrayType;
import net.sf.eBus.messages.type.BigDecimalType;
import net.sf.eBus.messages.type.BigIntegerType;
import net.sf.eBus.messages.type.BooleanType;
import net.sf.eBus.messages.type.ByteType;
import net.sf.eBus.messages.type.CharType;
import net.sf.eBus.messages.type.ClassType;
import net.sf.eBus.messages.type.ConcreteMessageType;
import net.sf.eBus.messages.type.DateType;
import net.sf.eBus.messages.type.DoubleType;
import net.sf.eBus.messages.type.DurationType;
import net.sf.eBus.messages.type.EnumType;
import net.sf.eBus.messages.type.FieldListType;
import net.sf.eBus.messages.type.FileType;
import net.sf.eBus.messages.type.FloatType;
import net.sf.eBus.messages.type.InetAddressType;
import net.sf.eBus.messages.type.InetSocketAddressType;
import net.sf.eBus.messages.type.InstantType;
import net.sf.eBus.messages.type.IntType;
import net.sf.eBus.messages.type.LocalDateTimeType;
import net.sf.eBus.messages.type.LocalDateType;
import net.sf.eBus.messages.type.LocalMessageType;
import net.sf.eBus.messages.type.LocalTimeType;
import net.sf.eBus.messages.type.LongType;
import net.sf.eBus.messages.type.MessageKeyType;
import net.sf.eBus.messages.type.MessageListType;
import net.sf.eBus.messages.type.MessageType;
import net.sf.eBus.messages.type.MonthDayType;
import net.sf.eBus.messages.type.OffsetDateTimeType;
import net.sf.eBus.messages.type.OffsetTimeType;
import net.sf.eBus.messages.type.PeriodType;
import net.sf.eBus.messages.type.ShortType;
import net.sf.eBus.messages.type.StringType;
import net.sf.eBus.messages.type.UriType;
import net.sf.eBus.messages.type.YearMonthType;
import net.sf.eBus.messages.type.YearType;
import net.sf.eBus.messages.type.ZoneIdType;
import net.sf.eBus.messages.type.ZoneOffsetType;
import net.sf.eBus.messages.type.ZonedDateTimeType;
import net.sf.eBus.util.MultiKey2;

public abstract class DataType
implements Comparable<DataType> {
    public static final int MAX_ARRAY_SIZE = 1000;
    public static final int MAX_STRING_LENGTH = 1024;
    public static final int MAX_FILE_NAME_LENGTH = 1024;
    public static final int MAX_FIELDS = 31;
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final String ARRAY_SUFFIX = "[]";
    public static final int VARIABLE_SIZE = Integer.MAX_VALUE;
    protected static final int FIELD_MASK_SIZE = 4;
    protected static final String EMPTY_STRING = "";
    protected static final String INDENT = "  ";
    protected static final String INDENT1 = "    ";
    protected static final StringType STRING_TYPE;
    protected static final InetAddressType ADDRESS_TYPE;
    protected static final ClassType CLASS_TYPE;
    protected static final MessageKeyType KEY_TYPE;
    private static final Map<Class<?>, DataType> sDataTypeMap;
    protected static final Map<String, Class<?>> sClasses;
    protected static final List<Class<? extends EMessageObject>> sCompiledClasses;
    protected transient Class<?> mClass;
    protected final boolean mBuiltinFlag;
    protected final int mSize;
    protected final Object mDefaultValue;

    protected DataType(Class<?> jClass, boolean builtinFlag, int size, Object defaultValue) {
        this.mClass = jClass;
        this.mBuiltinFlag = builtinFlag;
        this.mSize = size;
        this.mDefaultValue = defaultValue;
    }

    public abstract void serialize(Object var1, ByteBuffer var2) throws BufferOverflowException;

    public abstract Object deserialize(ByteBuffer var1) throws BufferUnderflowException, ValidationException;

    protected abstract void createSerializer(MessageType.MessageField var1, String var2, String var3, Formatter var4);

    protected abstract void createDeserializer(MessageType.MessageField var1, String var2, String var3, Formatter var4, boolean var5);

    @Override
    public int compareTo(DataType dataType) {
        return this.mClass.getName().compareTo(dataType.mClass.getName());
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = o == this;
        if (!retcode && o instanceof DataType) {
            DataType type = (DataType)o;
            retcode = this.mClass.equals(type.mClass);
        }
        return retcode;
    }

    public int hashCode() {
        return this.mClass.hashCode();
    }

    public String toString() {
        return this.mClass.getName();
    }

    public boolean isInstance(Object o) {
        return o == null || this.mClass.isAssignableFrom(o.getClass());
    }

    public final Class<?> dataClass() {
        return this.mClass;
    }

    public String dataClassName() {
        return this.mClass.getCanonicalName();
    }

    public final boolean isArray() {
        return this.mClass.isArray();
    }

    public final boolean isBuiltin() {
        return this.mBuiltinFlag;
    }

    public final boolean isPrimitive() {
        return this.mClass.isPrimitive();
    }

    public final boolean isEnum() {
        return this.mClass.isEnum();
    }

    public final boolean isMessage() {
        return EMessage.class.isAssignableFrom(this.mClass);
    }

    public boolean isLocalOnly() {
        return this.mClass.isAnnotationPresent(ELocalOnly.class);
    }

    public final int size() {
        return this.mSize;
    }

    public final Object defaultValue() {
        return this.mDefaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataType findType(Class<?> jClass) throws IllegalArgumentException, InvalidMessageException {
        DataType retval = null;
        Objects.requireNonNull(jClass, "jClass is null");
        Map<Class<?>, DataType> map = sDataTypeMap;
        synchronized (map) {
            if (sDataTypeMap.containsKey(jClass)) {
                retval = sDataTypeMap.get(jClass);
            } else if (jClass.isEnum()) {
                retval = new EnumType(jClass);
            } else if (jClass.isArray()) {
                DataType elementType = DataType.findType(jClass.getComponentType());
                if (elementType != null) {
                    retval = new ArrayType(jClass, elementType);
                }
            } else if (EMessageObject.class.isAssignableFrom(jClass)) {
                retval = jClass.isAnnotationPresent(ELocalOnly.class) ? LocalMessageType.createLocalMessageType(jClass) : ((jClass.getModifiers() & 0x400) == 1024 ? AbstractMessageType.createAbstractMessageType(jClass) : DataType.createConcreteMessageType(jClass));
            }
        }
        if (retval == null) {
            throw new IllegalArgumentException(String.format("%s is not a supported in eBus", jClass.getCanonicalName()));
        }
        sDataTypeMap.put(jClass, retval);
        return retval;
    }

    public static List<MultiKey2<String, DataType>> fields(Class<? extends EMessageObject> mc) throws IllegalArgumentException, InvalidMessageException {
        if (mc == null) {
            throw new IllegalArgumentException("mc is null");
        }
        MessageType msgType = (MessageType)DataType.findType(mc);
        List<MessageType.MessageField> fields = msgType.fields();
        int numFields = fields.size();
        ArrayList<MultiKey2<String, DataType>> retval = new ArrayList<MultiKey2<String, DataType>>(numFields);
        for (int index = 0; index < numFields; ++index) {
            MessageType.MessageField field = fields.get(index);
            retval.add((MultiKey2<String, DataType>)new MultiKey2((Object)field.name(), (Object)field.dataType()));
        }
        return retval;
    }

    private static DataType createConcreteMessageType(Class<?> jClass) throws InvalidMessageException {
        Class<?> mc = jClass;
        DataType retval = null;
        try {
            retval = DataType.compile(ConcreteMessageType.load(mc));
        }
        catch (IllegalAccessException | InstantiationException | CannotCompileException | NotFoundException jex) {
            throw new InvalidMessageException(mc, "failed to create " + mc.getCanonicalName() + " type", jex);
        }
        return retval;
    }

    private static DataType compile(ConcreteMessageType mt) throws CannotCompileException, NotFoundException, InstantiationException, IllegalAccessException {
        Class<?> mc = mt.dataClass();
        String className = String.format("__%sType__", mt.mClass.getSimpleName());
        String fqName = String.format("%s.%s", mc.getPackage().getName(), className);
        String ctor = String.format("public %s(java.util.List fields, java.util.List replies, java.lang.reflect.Method builder, java.lang.Class bc) {\n%ssuper (%s.class, fields, replies, builder, bc);\n}", className, INDENT, mc.getName());
        ClassPool pool = ClassPool.getDefault();
        int numBools = 0;
        CtClass retval = pool.makeClass(fqName);
        retval.setModifiers(17);
        retval.setSuperclass(pool.get(ConcreteMessageType.class.getName()));
        retval.addConstructor(CtNewConstructor.make((String)ctor, (CtClass)retval));
        numBools = mt.fields().stream().filter(field -> DataType.isBoolean(field.dataType().dataClass())).map(mItem -> 1).reduce(numBools, Integer::sum);
        if (numBools > 0) {
            retval.addMethod(CtNewMethod.make((String)DataType.serializeBooleans(mt), (CtClass)retval));
        }
        retval.addMethod(CtNewMethod.make((String)DataType.createSerializer(mt, numBools), (CtClass)retval));
        retval.addMethod(CtNewMethod.make((String)DataType.createDeserializer(mt, numBools), (CtClass)retval));
        return DataType.instantiateMessageType(mt, retval.toClass());
    }

    private static String createSerializer(MessageType mt, int numBools) {
        List<MessageType.MessageField> fields = mt.fields();
        Formatter retval = new Formatter();
        retval.format("protected int serializeFields(java.lang.Object o, java.nio.ByteBuffer buffer)%n", new Object[0]).format("%sthrows java.nio.BufferOverflowException%n", INDENT).format("{%n", new Object[0]).format("%1s%2$s value = (%2$s) o;%n", INDENT, mt.dataClassName()).format("%sint retval = 0x%x;%n", INDENT, DataType.fieldMask(fields));
        if (numBools > 0) {
            retval.format("%sbuffer.putInt(booleanMask(value));%n", INDENT);
        }
        retval.format("%n", new Object[0]);
        DataType.serializeFields(retval, fields);
        retval.format("  return (retval);%n", new Object[0]);
        retval.format("}", new Object[0]);
        return retval.toString();
    }

    private static String createDeserializer(ConcreteMessageType mt, int numBools) {
        boolean messageFlag = mt.isMessage();
        List<MessageType.MessageField> fields = mt.fields();
        Formatter retval = new Formatter();
        retval.format("protected java.lang.Object deserializeFields(int fieldMask, java.nio.ByteBuffer buffer)%n", new Object[0]).format("%sthrows java.lang.IllegalArgumentException,%n", INDENT).format("%s       java.nio.BufferUnderflowException,%n", INDENT).format("%s       net.sf.eBus.messages.ValidationException%n", INDENT).format("{%n", new Object[0]).format("%sfinal %s builder = %s.builder();%n%n", INDENT, mt.builderClassName(), mt.dataClassName());
        if (messageFlag) {
            retval.format("%sbuilder.subject(mSubject);%n", INDENT).format("%smSubject = null;%n%n", INDENT);
        }
        if (numBools > 0) {
            retval.format("%sfinal int boolMask = buffer.getInt();%n%n", INDENT);
            DataType.deserializeBooleans(retval, fields);
        }
        DataType.deserializeFields(retval, fields);
        retval.format("%sreturn (builder.build());%n", INDENT).format("}", new Object[0]);
        return retval.toString();
    }

    private static int fieldMask(List<MessageType.MessageField> fields) {
        int numFields = fields.size();
        int retval = 0;
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            DataType fieldType = fields.get(fieldIndex).dataType();
            if (!fieldType.isPrimitive() || fieldType.isArray()) continue;
            retval |= 1 << fieldIndex;
        }
        return retval;
    }

    private static boolean isBoolean(Class<?> dataClass) {
        return Boolean.TYPE.equals(dataClass) || Boolean.class.equals(dataClass);
    }

    private static void serializeFields(Formatter output, List<MessageType.MessageField> fields) {
        int numFields = fields.size();
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            MessageType.MessageField field = fields.get(fieldIndex);
            String fieldName = String.format("value.%s", field.name());
            DataType fieldType = field.dataType();
            if (DataType.isBoolean(fieldType.dataClass())) continue;
            if (fieldType.isPrimitive() && !fieldType.isArray()) {
                fieldType.createSerializer(field, fieldName, INDENT, output);
                continue;
            }
            output.format("%sif (%s != null) {%n", INDENT, fieldName);
            fieldType.createSerializer(field, fieldName, INDENT1, output);
            output.format("%sretval |= 0x%x;%n", INDENT1, 1 << fieldIndex).format("%s}%n", INDENT);
        }
    }

    private static String serializeBooleans(MessageType mt) {
        List<MessageType.MessageField> fields = mt.fields();
        int numFields = fields.size();
        Formatter retval = new Formatter();
        retval.format("private int booleanMask(%s value) {%n", mt.dataClassName()).format("%sint retval = 0;%n%n", INDENT);
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            MessageType.MessageField field = fields.get(fieldIndex);
            String fieldName = String.format("value.%s", field.name());
            Class<?> dataClass = field.dataType().dataClass();
            if (!DataType.isBoolean(dataClass)) continue;
            retval.format("%sif (", INDENT);
            if (Boolean.TYPE.equals(dataClass)) {
                retval.format("%s", fieldName);
            } else {
                retval.format("%1$s != null && %1$s.equals(java.lang.Boolean.TRUE)", fieldName);
            }
            retval.format(") {%n", new Object[0]).format("%sretval |= 0x%x;%n", INDENT1, 1 << fieldIndex).format("%s}%n%n", INDENT);
        }
        retval.format("%sreturn (retval);%n", INDENT).format("}", new Object[0]);
        return retval.toString();
    }

    private static void deserializeFields(Formatter output, List<MessageType.MessageField> fields) {
        int numFields = fields.size();
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            MessageType.MessageField field = fields.get(fieldIndex);
            String fieldName = field.name();
            DataType fieldType = field.dataType();
            if (DataType.isBoolean(fieldType.dataClass())) continue;
            if (fieldType.isPrimitive() && !fieldType.isArray()) {
                fieldType.createDeserializer(field, fieldName, INDENT, output, true);
                continue;
            }
            output.format("%sif ((fieldMask & 0x%x) == 0) {%n", INDENT, 1 << fieldIndex).format("%sbuilder.%s(null);%n", INDENT1, fieldName).format("%s} else {%n", INDENT);
            fieldType.createDeserializer(field, fieldName, INDENT1, output, true);
            output.format("%s}%n", INDENT);
        }
    }

    private static void deserializeBooleans(Formatter output, List<MessageType.MessageField> fields) {
        int numFields = fields.size();
        for (int fieldIndex = 0; fieldIndex < numFields; ++fieldIndex) {
            MessageType.MessageField field = fields.get(fieldIndex);
            Class<?> dataClass = field.dataType().dataClass();
            if (!DataType.isBoolean(dataClass)) continue;
            int fieldMask = 1 << fieldIndex;
            if (Boolean.TYPE.equals(dataClass)) {
                output.format("%1$sbuilder.%2$s((boolMask & 0x%3$x) == 0x%3$x);%n", INDENT, field.name(), fieldMask);
                continue;
            }
            output.format("%1$sbuilder.%2$s(((boolMask & 0x%3$x) == 0x%3$x) ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE);%n", INDENT, field.name(), fieldMask);
        }
    }

    private static DataType instantiateMessageType(ConcreteMessageType msgType, Class mc) throws InstantiationException {
        Object retval;
        try {
            Object[] args = new Object[]{msgType.fields(), msgType.replyTypes(), msgType.builder(), msgType.builderClass()};
            MethodHandles.Lookup lookup = MethodHandles.publicLookup();
            MethodType mt = MethodType.methodType(Void.TYPE, List.class, List.class, Method.class, Class.class);
            MethodHandle ctor = lookup.findConstructor(mc, mt);
            retval = ctor.invokeWithArguments(args);
        }
        catch (Throwable tex) {
            InstantiationException instex = new InstantiationException(String.format("failed to instantiate %s class", mc.getName()));
            instex.initCause(tex);
            throw instex;
        }
        return (DataType)retval;
    }

    public static List<Class<? extends EReplyMessage>> replyClasses(String[] args) {
        ArrayList<Class<? extends EReplyMessage>> retval = new ArrayList<Class<? extends EReplyMessage>>();
        if (args != null && args.length == 1 && args[0] != null && !args[0].isEmpty()) {
            try {
                Class<?> mc = Class.forName(args[0]);
                if (ERequestMessage.class.isAssignableFrom(mc)) {
                    MessageType.replyClasses(mc, retval);
                }
            }
            catch (ClassNotFoundException | InvalidMessageException exception) {
                // empty catch block
            }
        }
        return Collections.unmodifiableList(retval);
    }

    protected static Charset findCharset(String name) {
        Charset retval;
        try {
            retval = Charset.forName(name);
        }
        catch (Exception jex) {
            retval = CHARSET;
        }
        return retval;
    }

    static {
        sDataTypeMap = new ConcurrentHashMap();
        sClasses = new HashMap();
        sCompiledClasses = new ArrayList<Class<? extends EMessageObject>>();
        Class<Comparable<Boolean>> pType = Boolean.TYPE;
        sDataTypeMap.put(pType, new BooleanType(pType));
        sClasses.put(pType.getName(), pType);
        Class jType = Boolean.class;
        sDataTypeMap.put(jType, new BooleanType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Byte.TYPE;
        sDataTypeMap.put(pType, new ByteType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Byte.class;
        sDataTypeMap.put(jType, new ByteType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Character.TYPE;
        sDataTypeMap.put(pType, new CharType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Character.class;
        sDataTypeMap.put(jType, new CharType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Double.TYPE;
        sDataTypeMap.put(pType, new DoubleType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Double.class;
        sDataTypeMap.put(jType, new DoubleType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Float.TYPE;
        sDataTypeMap.put(pType, new FloatType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Float.class;
        sDataTypeMap.put(jType, new FloatType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Integer.TYPE;
        sDataTypeMap.put(pType, new IntType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Integer.class;
        sDataTypeMap.put(jType, new IntType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Long.TYPE;
        sDataTypeMap.put(pType, new LongType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Long.class;
        sDataTypeMap.put(jType, new LongType(jType));
        sClasses.put(jType.getName(), jType);
        pType = Short.TYPE;
        sDataTypeMap.put(pType, new ShortType(pType));
        sClasses.put(pType.getName(), pType);
        jType = Short.class;
        sDataTypeMap.put(jType, new ShortType(jType));
        sClasses.put(jType.getName(), jType);
        jType = Date.class;
        sDataTypeMap.put(jType, new DateType());
        sClasses.put(jType.getName(), jType);
        jType = String.class;
        STRING_TYPE = new StringType();
        sDataTypeMap.put(jType, STRING_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = URI.class;
        sDataTypeMap.put(jType, new UriType());
        sClasses.put(jType.getName(), jType);
        jType = File.class;
        sDataTypeMap.put(jType, new FileType());
        sClasses.put(jType.getName(), jType);
        jType = BigInteger.class;
        sDataTypeMap.put(jType, new BigIntegerType());
        sClasses.put(jType.getName(), jType);
        jType = BigDecimal.class;
        sDataTypeMap.put(jType, new BigDecimalType());
        sClasses.put(jType.getName(), jType);
        jType = Class.class;
        CLASS_TYPE = new ClassType();
        sDataTypeMap.put(jType, CLASS_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = EMessageKey.class;
        KEY_TYPE = new MessageKeyType();
        sDataTypeMap.put(jType, KEY_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = EMessageList.class;
        sDataTypeMap.put(jType, new MessageListType());
        sClasses.put(jType.getName(), jType);
        jType = EFieldList.class;
        sDataTypeMap.put(jType, new FieldListType());
        sClasses.put(jType.getName(), jType);
        ADDRESS_TYPE = new InetAddressType();
        jType = InetAddress.class;
        sDataTypeMap.put(jType, ADDRESS_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = Inet4Address.class;
        sDataTypeMap.put(jType, ADDRESS_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = Inet6Address.class;
        sDataTypeMap.put(jType, ADDRESS_TYPE);
        sClasses.put(jType.getName(), jType);
        jType = InetSocketAddress.class;
        sDataTypeMap.put(jType, new InetSocketAddressType());
        sClasses.put(jType.getName(), jType);
        jType = Duration.class;
        sDataTypeMap.put(jType, new DurationType());
        sClasses.put(jType.getName(), jType);
        jType = Instant.class;
        sDataTypeMap.put(jType, new InstantType());
        sClasses.put(jType.getName(), jType);
        jType = LocalDate.class;
        sDataTypeMap.put(jType, new LocalDateType());
        sClasses.put(jType.getName(), jType);
        jType = LocalTime.class;
        sDataTypeMap.put(jType, new LocalTimeType());
        sClasses.put(jType.getName(), jType);
        jType = LocalDateTime.class;
        sDataTypeMap.put(jType, new LocalDateTimeType());
        sClasses.put(jType.getName(), jType);
        jType = MonthDay.class;
        sDataTypeMap.put(jType, new MonthDayType());
        sClasses.put(jType.getName(), jType);
        jType = OffsetTime.class;
        sDataTypeMap.put(jType, new OffsetTimeType());
        sClasses.put(jType.getName(), jType);
        jType = OffsetDateTime.class;
        sDataTypeMap.put(jType, new OffsetDateTimeType());
        sClasses.put(jType.getName(), jType);
        jType = Period.class;
        sDataTypeMap.put(jType, new PeriodType());
        sClasses.put(jType.getName(), jType);
        jType = Year.class;
        sDataTypeMap.put(jType, new YearType());
        sClasses.put(jType.getName(), jType);
        jType = YearMonth.class;
        sDataTypeMap.put(jType, new YearMonthType());
        sClasses.put(jType.getName(), jType);
        jType = ZonedDateTime.class;
        sDataTypeMap.put(jType, new ZonedDateTimeType());
        sClasses.put(jType.getName(), jType);
        jType = ZoneId.class;
        sDataTypeMap.put(jType, new ZoneIdType());
        sClasses.put(jType.getName(), jType);
        jType = ZoneOffset.class;
        sDataTypeMap.put(jType, new ZoneOffsetType());
        sClasses.put(jType.getName(), jType);
    }
}

