/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.ESystemMessage;
import net.sf.eBus.messages.InvalidMessageException;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.MessageType;

public class ConcreteMessageType
extends MessageType {
    private final Method mBuilder;
    private final Class<? extends EMessageObject.Builder<?, ?>> mBuilderClass;

    protected ConcreteMessageType(Class<?> clazz, List<MessageType.MessageField> fields, List<Class<? extends EReplyMessage>> replies, Method builder, Class<? extends EMessageObject.Builder<?, ?>> bc) {
        super(clazz, fields, replies);
        this.mBuilder = builder;
        this.mBuilderClass = bc;
    }

    @Override
    public final void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o == null) {
            buffer.putInt(0);
        } else {
            int fieldMaskPosition = buffer.position();
            if (buffer.remaining() < 4) {
                throw new BufferOverflowException();
            }
            buffer.position(fieldMaskPosition + 4);
            buffer.putInt(fieldMaskPosition, this.serializeFields(o, buffer));
        }
    }

    @Override
    public final Object deserialize(ByteBuffer buffer) throws BufferUnderflowException, ValidationException {
        int fieldMask = buffer.getInt();
        assert (this.isMessage() && this.mSubject != null || !this.isMessage() && this.mSubject == null) : "subject incorrectly set for deserialization";
        return this.deserializeFields(fieldMask, buffer);
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        if (field.dataType().isMessage()) {
            output.format("%sSTRING_TYPE.serialize(((net.sf.eBus.messages.EMessage) %s).subject, buffer);%n", indent, fieldName);
        }
        output.format("%s(net.sf.eBus.messages.type.DataType.findType(%s.class)).serialize(%s, buffer);%n", indent, field.javaType().getCanonicalName(), fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        output.format("%snet.sf.eBus.messages.type.MessageType mt = (net.sf.eBus.messages.type.MessageType) net.sf.eBus.messages.type.DataType.findType(%s.class);%n%n", indent, field.javaType().getCanonicalName());
        if (field.dataType().isMessage()) {
            output.format("%smt.subject((java.lang.String) STRING_TYPE.serialize(((net.sf.eBus.messages.EMessage) %s).subject, buffer));%n", indent, fieldName);
        }
        String format = useBuilder ? "%sbuilder.%s((%s) mt.deserialize(buffer));%n" : "%s%s = (%s) mt.deserialize(buffer);%n";
        String fieldType = field.javaType().getCanonicalName();
        if (field.isArray()) {
            fieldType = fieldType.substring(0, fieldType.length() - 2);
        }
        output.format(format, indent, fieldName, fieldType);
    }

    public Method builder() {
        return this.mBuilder;
    }

    public Class<? extends EMessageObject.Builder<?, ?>> builderClass() {
        return this.mBuilderClass;
    }

    public String builderClassName() {
        return this.mBuilderClass.getCanonicalName();
    }

    static ConcreteMessageType load(Class<? extends EMessageObject> mc) throws InvalidMessageException {
        Class<? extends EMessageObject.Builder<?, ?>> bc;
        Method builder;
        List<MessageType.MessageField> fields = ConcreteMessageType.findFields(mc);
        ArrayList<Class<? extends EReplyMessage>> replyClasses = new ArrayList<Class<? extends EReplyMessage>>();
        try {
            builder = ConcreteMessageType.findBuilder(mc);
            bc = ConcreteMessageType.findBuilderClass(mc, builder, fields);
        }
        catch (NoSuchMethodException methex) {
            throw new InvalidMessageException(mc, methex.getMessage(), methex);
        }
        if (ERequestMessage.class.isAssignableFrom(mc)) {
            ConcreteMessageType.replyClasses(mc, replyClasses);
        }
        ConcreteMessageType.setSetters(bc, fields);
        return new ConcreteMessageType(mc, Collections.unmodifiableList(fields), Collections.unmodifiableList(replyClasses), builder, bc);
    }

    private static Method findBuilder(Class<? extends EMessageObject> mc) throws NoSuchMethodException {
        Method retval = mc.getMethod("builder", new Class[0]);
        if ((retval.getModifiers() & 9) != 9) {
            throw new NoSuchMethodException("builder method is not public final");
        }
        return retval;
    }

    private static Class<? extends EMessageObject.Builder<?, ?>> findBuilderClass(Class<? extends EMessageObject> mc, Method builder, List<MessageType.MessageField> fields) throws NoSuchMethodException {
        Class<?> retval = builder.getReturnType();
        Class<EMessageObject.Builder<?, ?>> baseBuilder = ConcreteMessageType.baseBuilder(mc);
        int modifiers = retval.getModifiers();
        if (!baseBuilder.isAssignableFrom(retval)) {
            throw new NoSuchMethodException(retval.getCanonicalName() + " does not extend " + baseBuilder.getCanonicalName());
        }
        if ((modifiers & 9) != 9) {
            throw new NoSuchMethodException(retval.getCanonicalName() + " is not public");
        }
        ConcreteMessageType.checkSetters(retval, fields);
        return retval;
    }

    private static Class<? extends EMessageObject.Builder<?, ?>> baseBuilder(Class<? extends EMessageObject> mc) {
        Class retval = ENotificationMessage.class.isAssignableFrom(mc) ? ENotificationMessage.Builder.class : (ERequestMessage.class.isAssignableFrom(mc) ? ERequestMessage.Builder.class : (EReplyMessage.class.isAssignableFrom(mc) ? EReplyMessage.Builder.class : (ESystemMessage.class.isAssignableFrom(mc) ? ESystemMessage.Builder.class : EMessageObject.Builder.class)));
        return retval;
    }

    private static void checkSetters(Class<?> bc, List<MessageType.MessageField> fields) throws NoSuchMethodException {
        String methodName = "(not set)";
        for (MessageType.MessageField mf : fields) {
            try {
                methodName = mf.name();
                Method m = bc.getMethod(methodName, mf.dataType().dataClass());
                Class<?> rt = m.getReturnType();
                if ((m.getModifiers() & 1) == 0) {
                    throw new NoSuchMethodException(methodName + " not public");
                }
                if (rt.isAssignableFrom(bc)) continue;
                throw new NoSuchMethodException(methodName + " return type " + rt.getCanonicalName() + " not " + bc.getCanonicalName());
            }
            catch (NoSuchMethodException | SecurityException secex) {
                throw new NoSuchMethodException(bc.getCanonicalName() + " does not have a setter method for " + methodName);
            }
        }
    }

    private static void setSetters(Class<? extends EMessageObject.Builder<?, ?>> bc, List<MessageType.MessageField> fields) {
        MethodHandles.Lookup lookup = MethodHandles.publicLookup();
        for (MessageType.MessageField mf : fields) {
            MethodType setterType = MethodType.methodType(bc, mf.dataType().dataClass());
            try {
                mf.setter(lookup.findVirtual(bc, mf.name(), setterType));
            }
            catch (IllegalAccessException | NoSuchMethodException reflectiveOperationException) {}
        }
    }
}

