/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ClassType
extends DataType {
    ClassType() {
        super(Class.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof Class) {
            STRING_TYPE.serialize(((Class)o).getName(), buffer);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        String name = (String)STRING_TYPE.deserialize(buffer);
        Class<?> retval = null;
        if (name != null && !name.isEmpty() && (retval = (Class<?>)sClasses.get(name)) == null) {
            try {
                retval = Class.forName(name);
                sClasses.put(name, retval);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sfinal String name = (%s).getName();%n", indent, fieldName);
        STRING_TYPE.createSerializer(field, "name", indent, output);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String indent2 = indent1 + "  ";
        String indent3 = indent2 + "  ";
        output.format("%sjava.lang.String _name;%n", indent);
        STRING_TYPE.createDeserializer(field, "_name", indent, output, false);
        output.format("%sif (_name != null && !_name.isEmpty()) {%n", indent).format("%s java.lang.Class _clazz = (java.lang.Class) sClasses.get(_name);%n", indent1).format("%sif (_clazz == null) {%n", indent1).format("%stry {%n", indent2).format("%s_clazz = Class.forName(_name);%n", indent3).format("%ssClasses.put(_name, _clazz);%n", indent3).format("%s} catch (ClassNotFoundException classex) {%n", indent2).format("%s_clazz = null;%n", indent3).format("%s}%n", indent2).format("%s}%n", indent1).format(useBuilder ? "%sbuilder.%s(_clazz);%n" : "%s%s = _clazz;%n", indent1, fieldName).format("%s}%n", indent);
    }
}

