/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.math.BigInteger;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class BigIntegerType
extends DataType {
    BigIntegerType() {
        super(BigInteger.class, true, Integer.MAX_VALUE, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof BigInteger) {
            byte[] b = ((BigInteger)o).toByteArray();
            buffer.putShort((short)b.length);
            buffer.put(b);
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        short size = buffer.getShort();
        BigInteger retval = null;
        if (size > 0) {
            byte[] b = new byte[size];
            buffer.get(b);
            retval = new BigInteger(b);
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        String indent1 = indent + "  ";
        output.format("%sfinal byte[] bytes = (%s).toByteArray();%n", indent, fieldName);
        output.format("%sbuffer.putShort((short) bytes.length);%n", indent);
        output.format("%sif (bytes.length > 0) {%n", indent);
        output.format("%sbuffer.put(bytes);%n", indent1);
        output.format("%s}%n", indent);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        String format = useBuilder ? "%sbuilder.%s(new java.math.BigInteger(b));%n" : "%s%s = new java.math.BigInteger(b);%n";
        output.format("%sfinal int size = buffer.getShort();%n", indent).format("%sif (size == 0) {%n", indent).format("%sbuilder.%s(null);%n", indent1, fieldName).format("%s} else {%n", indent).format("%sfinal byte[] b = new byte[size];%n", indent1).format("%sbuffer.get(b);%n", indent1).format(format, indent1, fieldName).format("%s}%n", indent);
    }
}

