/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.math.BigDecimal;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class BigDecimalType
extends DataType {
    public static final int BYTES = 12;

    BigDecimalType() {
        super(BigDecimal.class, true, 12, null);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)o;
            buffer.putLong(bd.unscaledValue().longValue()).putInt(bd.scale());
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        return BigDecimal.valueOf(buffer.getLong(), buffer.getInt());
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sbuffer.putLong(((%s).unscaledValue()).longValue())%n", indent, fieldName);
        output.format("%s      .putInt((%s).scale());%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String format = useBuilder ? "%sbuilder.%s(java.math.BigDecimal.valueOf(buffer.getLong(), buffer.getInt()));%n" : "%s%s = java.math.BigDecimal.valueOf(buffer.getLong(), buffer.getInt()));%n";
        output.format(format, indent, fieldName);
    }
}

