/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.lang.reflect.Array;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Formatter;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class ArrayType
extends DataType {
    private final DataType mSubtype;

    public ArrayType(Class<?> jClass, DataType subtype) {
        super(jClass, true, Integer.MAX_VALUE, null);
        this.mSubtype = subtype;
    }

    @Override
    public boolean isInstance(Object o) {
        return o == null || this.mClass.isInstance(o);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        if (o != null) {
            int size = Array.getLength(o);
            if (size > 1000) {
                BufferOverflowException bufex = new BufferOverflowException();
                bufex.initCause(new IllegalArgumentException(String.format("array length %,d exceeds max allowed size %,d", size, 1000)));
                throw bufex;
            }
            buffer.putShort((short)size);
            if (Byte.TYPE.equals(this.mSubtype.dataClass())) {
                buffer.put((byte[])o);
            } else {
                for (int index = 0; index < size; ++index) {
                    this.mSubtype.serialize(Array.get(o, index), buffer);
                }
            }
        }
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws BufferUnderflowException {
        int size = buffer.getShort();
        Object retval = null;
        if (size < 0 || size > 1000) {
            BufferUnderflowException bufex = new BufferUnderflowException();
            bufex.initCause(new IllegalArgumentException("invalid array size " + size));
            throw bufex;
        }
        if (Byte.TYPE.equals(this.mSubtype.dataClass())) {
            retval = new byte[size];
            buffer.get((byte[])retval);
        } else {
            retval = Array.newInstance(this.mSubtype.dataClass(), size);
            for (int index = 0; index < size; ++index) {
                Array.set(retval, index, this.mSubtype.deserialize(buffer));
            }
        }
        return retval;
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        String indent1 = indent + "  ";
        output.format("%sif ((%s).length > MAX_ARRAY_SIZE) {%n", indent, fieldName);
        output.format("%sfinal java.nio.BufferOverflowException bufex = new java.nio.BufferOverflowException();%n", indent1);
        output.format("%sbufex.initCause(new IllegalArgumentException(\"array length exceeds MAX_ARRAY_SIZE\"));%n", indent1);
        output.format("%sthrow (bufex);%n", indent1);
        output.format("%s}%n", indent);
        output.format("%sbuffer.putShort((short) (%s).length);%n", indent, fieldName);
        if (Byte.TYPE.equals(this.mSubtype.dataClass())) {
            output.format("%sbuffer.put(%s);%n", indent, fieldName);
        } else {
            String subtypeName = String.format("%s[index]", fieldName);
            output.format("%sfor (int index = 0; index < (%s).length; ++index) {%n", indent, fieldName);
            this.mSubtype.createSerializer(field, subtypeName, indent1, output);
            output.format("%s}%n", indent);
        }
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        String indent1 = indent + "  ";
        output.format("%sfinal int arraySize = (int) buffer.getShort();%n", indent).format("%sif (arraySize < 0 || arraySize > MAX_ARRAY_SIZE) {%n", indent).format("%sfinal java.nio.BufferUnderflowException bufex = new java.nio.BufferUnderflowException();%n", indent1).format("%sbufex.initCause(new IllegalArgumentException(\"invalid array size\"));%n", indent1).format("%sthrow (bufex);%n", indent1).format("%s}%n", indent).format("%1$sfinal %2$s[] arrayValue = new %2$s[arraySize];%n", indent, this.mSubtype.dataClassName());
        if (Byte.TYPE.equals(this.mSubtype.dataClass())) {
            output.format("%sbuffer.get(arrayValue);%n", indent);
        } else {
            output.format("%sfor (int i = 0; i < arraySize; ++i) {%n", indent);
            this.mSubtype.createDeserializer(field, "arrayValue[i]", indent1, output, false);
            output.format("%s}%n", indent);
        }
        output.format("%sbuilder.%s(arrayValue);%n", indent, fieldName);
    }

    @Override
    public String dataClassName() {
        return String.format("%s[]", this.mSubtype.dataClassName());
    }

    public DataType subtype() {
        return this.mSubtype;
    }

    @Override
    public String toString() {
        return String.format("%s[]", this.mSubtype);
    }
}

