/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages.type;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.UnknownMessageException;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.DataType;
import net.sf.eBus.messages.type.MessageType;

public final class AbstractMessageType
extends MessageType {
    AbstractMessageType(Class<?> clazz, List<MessageType.MessageField> fields, List<Class<? extends EReplyMessage>> replies) {
        super(clazz, fields, replies);
    }

    @Override
    public void serialize(Object o, ByteBuffer buffer) throws BufferOverflowException {
        Class<?> mc = this.getClass();
        MessageType mt = (MessageType)DataType.findType(mc);
        CLASS_TYPE.serialize(mc, buffer);
        if (mt.isMessage()) {
            STRING_TYPE.serialize(((EMessage)o).subject, buffer);
        }
        mt.serialize(o, buffer);
    }

    @Override
    public Object deserialize(ByteBuffer buffer) throws IllegalStateException, BufferUnderflowException, UnknownMessageException, ValidationException {
        Class mc = (Class)CLASS_TYPE.deserialize(buffer);
        MessageType mt = (MessageType)DataType.findType(mc);
        if (mt.isMessage()) {
            mt.subject((String)STRING_TYPE.deserialize(buffer));
        }
        return mt.deserialize(buffer);
    }

    @Override
    protected void createSerializer(MessageType.MessageField field, String fieldName, String indent, Formatter output) {
        output.format("%sjava.lang.Class mc = (%s).getClass();%n", indent, fieldName);
        output.format("%snet.sf.eBus.messages.type.MessageType mt = (net.sf.eBus.messages.type.MessageType) net.sf.eBus.messages.type.DataType.findType(mc);%n%n", indent);
        output.format("%sCLASS_TYPE.serialize(mc, buffer);%n", indent);
        output.format("%sif (mt.isMessage()) {%n", indent);
        output.format("%s  STRING_TYPE.serialize(((net.sf.eBus.messages.EMessage) %s).subject, buffer);%n", indent, fieldName);
        output.format("%s}%n%n", indent);
        output.format("%smt.serialize(%s, buffer);%n", indent, fieldName);
    }

    @Override
    protected void createDeserializer(MessageType.MessageField field, String fieldName, String indent, Formatter output, boolean useBuilder) {
        output.format("%sjava.lang.Class mc = (java.lang.Class) CLASS_TYPE.deserialize(buffer);%n", indent);
        output.format("%snet.sf.eBus.messages.type.MessageType mt = (net.sf.eBus.messages.type.MessageType) net.sf.eBus.messages.type.DataType.findType(mc);%n%n", indent);
        output.format("%sif (mt.isMessage()) {%n", indent);
        output.format("%s  mt.subject((java.lang.String) STRING_TYPE.deserialize(buffer));%n", indent);
        output.format("%s}%n%n", indent);
        String format = useBuilder ? "%sbuilder.%s((%s) mt.deserialize(buffer));%n" : "%s%s = (%s) mt.deserialize(buffer);%n";
        output.format(format, indent, fieldName, this.mClass.getName());
    }

    static DataType createAbstractMessageType(Class<? extends EMessageObject> jClass) {
        List<MessageType.MessageField> fields = AbstractMessageType.findFields(jClass);
        ArrayList<Class<? extends EReplyMessage>> replyClasses = new ArrayList<Class<? extends EReplyMessage>>();
        if (EReplyMessage.class.isAssignableFrom(jClass)) {
            AbstractMessageType.replyClasses(jClass, replyClasses);
        }
        return new AbstractMessageType(jClass, fields, replyClasses);
    }
}

