/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.eBus.messages.EMessageObject;

public final class ValidationException
extends RuntimeException {
    private static final long serialVersionUID = 328192L;
    private final Class<? extends EMessageObject> mClass;
    private final List<String> mProblems;

    public ValidationException(Class<? extends EMessageObject> mc, List<String> problems) {
        super(ValidationException.asMessage(mc, problems));
        this.mClass = mc;
        this.mProblems = new ArrayList<String>(problems);
    }

    @Override
    public String toString() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.mClass.getCanonicalName()).append(" validation failures:").append(this.getMessage());
        return retval.toString();
    }

    public Class<? extends EMessageObject> messageClass() {
        return this.mClass;
    }

    public Iterable<String> problems() {
        return Collections.unmodifiableList(this.mProblems);
    }

    private static String asMessage(Class<? extends EMessageObject> mc, List<String> problems) {
        StringBuilder retval = new StringBuilder();
        retval.append(mc.getCanonicalName()).append(" failed to build due to the following problems:");
        problems.forEach(problem -> retval.append('\n').append((String)problem));
        return retval.toString();
    }
}

