/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.Optional;

public class EReplyMessage
extends EMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final ReplyStatus replyStatus;
    @Optional
    public final String replyReason;

    public EReplyMessage(String subject, ReplyStatus replyStatus, String replyReason) throws IllegalArgumentException {
        this(subject, System.currentTimeMillis(), replyStatus, replyReason);
    }

    public EReplyMessage(String subject, long timestamp, ReplyStatus replyStatus, String replyReason) throws IllegalArgumentException {
        super(subject, timestamp, EMessage.MessageType.REPLY);
        if (replyStatus == null) {
            throw new IllegalArgumentException("null replyStatus");
        }
        this.replyStatus = replyStatus;
        this.replyReason = replyReason;
    }

    protected EReplyMessage(Builder<?, ?> builder) {
        super((EMessage.Builder<?, ?>)builder);
        this.replyStatus = builder.mReplyStatus;
        this.replyReason = builder.mReplyReason;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode = super.equals(o);
        if (retcode) {
            if (!(o instanceof EReplyMessage)) {
                retcode = false;
            } else {
                EReplyMessage msg = (EReplyMessage)o;
                retcode = this.replyStatus == msg.replyStatus && (this.replyReason == null ? msg.replyReason == null : this.replyReason.equals(msg.replyReason));
            }
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        int reasonHash = this.replyReason == null ? 0 : this.replyReason.hashCode();
        return (super.hashCode() * 37 + this.replyStatus.ordinal()) * 37 + reasonHash;
    }

    @Override
    public String toString() {
        return String.format("%s%n           reply status: %s%n           reply reason: %s", new Object[]{super.toString(), this.replyStatus, this.replyReason == null ? "(no reason)" : this.replyReason});
    }

    public boolean isFinal() {
        return this.replyStatus.isFinal();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public static final class ConcreteBuilder
    extends Builder<EReplyMessage, ConcreteBuilder> {
        private ConcreteBuilder() {
            super(EReplyMessage.class);
        }

        @Override
        protected EReplyMessage buildImpl() {
            return new EReplyMessage(this);
        }
    }

    public static abstract class Builder<M extends EReplyMessage, B extends Builder<M, ?>>
    extends EMessage.Builder<M, B> {
        @Nonnull
        protected ReplyStatus mReplyStatus;
        @Nullable
        protected String mReplyReason;

        protected Builder(Class<? extends EMessageObject> targetClass) {
            super(targetClass, EMessage.MessageType.REPLY);
        }

        @Override
        protected void validate(List<String> problems) {
            if (this.mReplyStatus == null) {
                problems.add("reply status not set");
            }
        }

        public final B replyStatus(ReplyStatus status) {
            this.mReplyStatus = Objects.requireNonNull(status, "status is null");
            return (B)this;
        }

        public final B replyReason(String reason) {
            this.mReplyReason = reason;
            return (B)this;
        }
    }

    public static enum ReplyStatus {
        OK_FINAL(true),
        OK_CONTINUING(false),
        ERROR(true);

        private final boolean mFinalReply;

        private ReplyStatus(boolean finalReply) {
            this.mFinalReply = finalReply;
        }

        public boolean isFinal() {
            return this.mFinalReply;
        }
    }
}

