/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.sf.eBus.messages.InvalidMessageException;
import net.sf.eBus.messages.ValidationException;
import net.sf.eBus.messages.type.DataType;

public abstract class EMessageObject
implements Serializable {
    public static final int MAX_FIELDS = 31;
    private static final long serialVersionUID = 328192L;
    private static final ConcurrentMap<Class<? extends EMessageObject>, ValidationInfo> mValidMap = new ConcurrentHashMap<Class<? extends EMessageObject>, ValidationInfo>();

    protected EMessageObject() throws InvalidMessageException {
        Class<?> mc = this.getClass();
        ValidationInfo info = (ValidationInfo)mValidMap.get(mc);
        if (info == null) {
            info = EMessageObject.validate(mc);
            mValidMap.put(mc, info);
        }
        if (!info.isValid()) {
            throw new InvalidMessageException(mc, info.reason(), info.error());
        }
    }

    protected EMessageObject(Builder<?, ?> builder) {
    }

    private static ValidationInfo validate(Class<? extends EMessageObject> mc) {
        boolean flag = true;
        String reason = null;
        InvalidMessageException t = null;
        try {
            DataType.findType(mc);
        }
        catch (InvalidMessageException msgex) {
            flag = false;
            reason = msgex.getMessage();
            t = msgex;
        }
        return new ValidationInfo(flag, reason, t);
    }

    private static final class ValidationInfo {
        private final boolean mFlag;
        private final String mReason;
        private final Throwable mError;

        private ValidationInfo(boolean flag, String reason, Throwable t) {
            this.mFlag = flag;
            this.mReason = reason;
            this.mError = t;
        }

        private boolean isValid() {
            return this.mFlag;
        }

        private String reason() {
            return this.mReason;
        }

        private Throwable error() {
            return this.mError;
        }
    }

    public static abstract class Builder<M extends EMessageObject, B extends Builder<M, ?>> {
        protected final Class<? extends EMessageObject> mTargetClass;

        protected Builder(Class<? extends EMessageObject> targetClass) {
            this.mTargetClass = targetClass;
        }

        protected abstract M buildImpl();

        protected void validate(List<String> problems) {
        }

        public final M build() throws ValidationException {
            ArrayList<String> problems = new ArrayList<String>();
            this.validate(problems);
            if (!problems.isEmpty()) {
                throw new ValidationException(this.mTargetClass, problems);
            }
            return this.buildImpl();
        }
    }
}

