/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.io.Serializable;
import java.util.Collection;
import net.sf.eBus.messages.EAbstractList;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;

public final class EMessageList<E extends EMessage>
extends EAbstractList<E>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 328192L;
    private final EMessageKey mKey;

    public EMessageList(EMessageKey key) throws NullPointerException {
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.mKey = key;
        this.mReadOnlyFlag = false;
    }

    public EMessageList(int initialCapacity, EMessageKey key) throws NullPointerException {
        super(initialCapacity);
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        this.mKey = key;
        this.mReadOnlyFlag = false;
    }

    public EMessageList(Collection<E> c, EMessageKey key) throws NullPointerException, IllegalArgumentException {
        super(c);
        if (key == null) {
            throw new NullPointerException("key is null");
        }
        EMessageList.validate(c, key);
        this.mKey = key;
        this.mReadOnlyFlag = false;
    }

    @Override
    public boolean add(E e) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!((EMessage)e).key().equals(this.mKey)) {
            throw new IllegalArgumentException("e has incorrect message key");
        }
        return super.add(e);
    }

    @Override
    public void add(int index, E e) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!((EMessage)e).key().equals(this.mKey)) {
            throw new IllegalArgumentException("e has incorrect message key");
        }
        super.add(index, e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) throws NullPointerException, IllegalArgumentException, UnsupportedOperationException {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        if (c == null) {
            throw new NullPointerException("c is null");
        }
        EMessageList.validate(c, this.mKey);
        return super.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        if (c == null) {
            throw new NullPointerException("c is null");
        }
        EMessageList.validate(c, this.mKey);
        return super.addAll(index, c);
    }

    @Override
    public E set(int index, E e) throws NullPointerException, IllegalArgumentException, IndexOutOfBoundsException, UnsupportedOperationException {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        if (e == null) {
            throw new NullPointerException("e is null");
        }
        if (!((EMessage)e).key().equals(this.mKey)) {
            throw new IllegalArgumentException("e has incorrect message key");
        }
        return (E)((EMessage)super.set(index, e));
    }

    public EMessageKey key() {
        return this.mKey;
    }

    private static void validate(Collection<? extends EMessage> c, EMessageKey key) throws IllegalArgumentException {
        c.forEach((? super T msg) -> {
            if (msg == null) {
                throw new IllegalArgumentException("collection contains null message");
            }
            if (!msg.key().equals(key)) {
                throw new IllegalArgumentException("collection contains message with incorrect key");
            }
        });
    }
}

