/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.io.Serializable;
import java.util.Objects;
import net.sf.eBus.messages.ELocalOnly;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.ESystemMessage;
import net.sf.eBus.messages.InvalidMessageException;

public class EMessageKey
implements Comparable<EMessageKey>,
Serializable {
    public static final char KEY_IFS = '/';
    private static final String KEY_FORMAT = "%s/%s";
    private static final long serialVersionUID = 328192L;
    private final Class<? extends EMessage> mMessageClass;
    private final String mMessageClassessageSubject;
    private int mHashCode;
    private String mKeyString;

    public EMessageKey(Class<? extends EMessage> mc, String subject) {
        this.mMessageClass = Objects.requireNonNull(mc, "mc is null");
        this.mMessageClassessageSubject = Objects.requireNonNull(subject, "subject is null");
        this.mKeyString = null;
        this.mHashCode = 0;
        if (subject.isEmpty()) {
            throw new IllegalArgumentException("empty subject");
        }
    }

    @Override
    public int compareTo(EMessageKey key) {
        int retval = this.mMessageClass.getName().compareTo(key.mMessageClass.getName());
        if (retval == 0) {
            retval = this.mMessageClassessageSubject.compareTo(key.mMessageClassessageSubject);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        boolean retcode;
        boolean bl = retcode = this == obj;
        if (!retcode && obj instanceof EMessageKey) {
            EMessageKey key = (EMessageKey)obj;
            retcode = this.mMessageClass.equals(key.mMessageClass) && this.mMessageClassessageSubject.equals(key.mMessageClassessageSubject);
        }
        return retcode;
    }

    public int hashCode() {
        if (this.mHashCode == 0) {
            this.mHashCode = this.mMessageClass.hashCode() * 37 + this.mMessageClassessageSubject.hashCode();
        }
        return this.mHashCode;
    }

    public String toString() {
        return this.mMessageClass.getName() + '/' + this.mMessageClassessageSubject;
    }

    public String className() {
        return this.mMessageClass.getName();
    }

    public Class<? extends EMessage> messageClass() {
        return this.mMessageClass;
    }

    public String subject() {
        return this.mMessageClassessageSubject;
    }

    public String keyString() {
        if (this.mKeyString == null) {
            this.mKeyString = String.format(KEY_FORMAT, this.mMessageClass.getName(), this.mMessageClassessageSubject);
        }
        return this.mKeyString;
    }

    public boolean isSystem() {
        return ESystemMessage.class.isAssignableFrom(this.mMessageClass);
    }

    public boolean isNotification() {
        return ENotificationMessage.class.isAssignableFrom(this.mMessageClass);
    }

    public boolean isRequest() {
        return ERequestMessage.class.isAssignableFrom(this.mMessageClass);
    }

    public boolean isReply() {
        return EReplyMessage.class.isAssignableFrom(this.mMessageClass);
    }

    public boolean isLocalOnly() {
        return this.mMessageClass.isAnnotationPresent(ELocalOnly.class);
    }

    public EMessage.MessageType messageType() {
        EMessage.MessageType retval = ENotificationMessage.class.isAssignableFrom(this.mMessageClass) ? EMessage.MessageType.NOTIFICATION : (ERequestMessage.class.isAssignableFrom(this.mMessageClass) ? EMessage.MessageType.REQUEST : (EReplyMessage.class.isAssignableFrom(this.mMessageClass) ? EMessage.MessageType.REPLY : EMessage.MessageType.SYSTEM));
        return retval;
    }

    public static EMessageKey parseKey(String s) throws IllegalArgumentException, InvalidMessageException {
        EMessageKey retval = null;
        if (s != null && !s.isEmpty()) {
            String[] tokens = s.split(":");
            if (tokens.length != 2) {
                throw new IllegalArgumentException(String.format("invalid message key \"%s\"", s));
            }
            try {
                Class<?> clazz = Class.forName(tokens[0]);
                if (!EMessage.class.isAssignableFrom(clazz)) {
                    throw new InvalidMessageException(EMessage.class, String.format("%s is not a EMessage subclass", tokens[0]));
                }
                retval = new EMessageKey(clazz, tokens[1]);
            }
            catch (ClassNotFoundException classex) {
                throw new IllegalArgumentException(String.format("%s is an unknown class", tokens[0]), classex);
            }
        }
        return retval;
    }
}

