/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.net.SocketAddress;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageKey;

public final class EMessageHeader {
    public static final int NO_ID = -1;
    private final int mClassId;
    private final int mFromFeedId;
    private final int mToFeedId;
    private final SocketAddress mAddress;
    private final EMessage mMessage;

    public EMessageHeader(int classId, int fromFeedId, int toFeedId, EMessage msg) {
        this(classId, fromFeedId, toFeedId, null, msg);
    }

    public EMessageHeader(int classId, int fromFeedId, int toFeedId, SocketAddress address, EMessage msg) {
        if (msg == null) {
            throw new IllegalArgumentException("null msg");
        }
        if (msg.isApplicationMessage()) {
            if (classId < 0) {
                throw new IllegalArgumentException("classId < 0");
            }
            if (fromFeedId < 0) {
                throw new IllegalArgumentException("fromProxyId < 0");
            }
        }
        this.mClassId = classId;
        this.mFromFeedId = fromFeedId;
        this.mToFeedId = toFeedId;
        this.mAddress = address;
        this.mMessage = msg;
    }

    public Class<? extends EMessage> messageClass() {
        return this.mMessage.getClass();
    }

    public boolean isSystemMessage() {
        return this.mMessage.messageType() == EMessage.MessageType.SYSTEM;
    }

    public EMessage.MessageType messageType() {
        return this.mMessage.messageType();
    }

    public EMessageKey messageKey() {
        return this.mMessage.key();
    }

    public int classId() {
        return this.mClassId;
    }

    public int fromFeedId() {
        return this.mFromFeedId;
    }

    public int toFeedId() {
        return this.mToFeedId;
    }

    public SocketAddress address() {
        return this.mAddress;
    }

    public EMessage message() {
        return this.mMessage;
    }

    public String toString() {
        return String.format("[key=%d,from=%d;to=%d]%n%s", this.mClassId, this.mFromFeedId, this.mToFeedId, this.mMessage);
    }
}

