/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.ENotificationMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.ERequestMessage;
import net.sf.eBus.messages.ESystemMessage;
import net.sf.eBus.messages.InvalidMessageException;

public abstract class EMessage
extends EMessageObject
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final String subject;
    public final long timestamp;
    private final MessageType mMessageType;
    private final EMessageKey mKey;

    @Deprecated
    public EMessage(String subject, long timestamp) throws IllegalArgumentException, InvalidMessageException {
        this(subject, timestamp, MessageType.SYSTEM);
    }

    EMessage(String subject, long timestamp, MessageType msgType) throws IllegalArgumentException, InvalidMessageException {
        if (subject == null || subject.isEmpty()) {
            throw new IllegalArgumentException("null or empty subject");
        }
        if (msgType == null) {
            throw new IllegalArgumentException("null msgType");
        }
        this.subject = subject;
        this.timestamp = timestamp;
        this.mMessageType = msgType;
        this.mKey = new EMessageKey(this.getClass(), subject);
    }

    protected EMessage(Builder<?, ?> builder) {
        this.subject = ((Builder)builder).mSubject;
        this.timestamp = ((Builder)builder).mTimestamp;
        this.mMessageType = ((Builder)builder).mType;
        this.mKey = new EMessageKey(this.getClass(), this.subject);
    }

    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof EMessage) {
            EMessage msg = (EMessage)o;
            retcode = this.subject.equals(msg.subject) && this.timestamp == msg.timestamp;
        }
        return retcode;
    }

    public int hashCode() {
        return this.subject.hashCode() * 37 + Long.valueOf(this.timestamp).hashCode();
    }

    public String toString() {
        return String.format("%1$s:%2$s%n              timestamp: %3$tY/%3$tm/%3$td %3$tH:%3$tM:%3$tS.%3$tL", this.getClass(), this.subject, new Date(this.timestamp));
    }

    public EMessageKey key() {
        return this.mKey;
    }

    public MessageType messageType() {
        return this.mMessageType;
    }

    public boolean isSystemMessage() {
        return this.mMessageType == MessageType.SYSTEM;
    }

    public boolean isApplicationMessage() {
        return this.mMessageType != MessageType.SYSTEM;
    }

    public static abstract class Builder<M extends EMessage, B extends Builder<M, ?>>
    extends EMessageObject.Builder<M, B> {
        private String mSubject;
        private long mTimestamp;
        private final MessageType mType;

        protected Builder(Class<? extends EMessageObject> targetClass, MessageType type) {
            this(targetClass, null, Long.MIN_VALUE, type);
        }

        protected Builder(Class<? extends EMessageObject> targetClass, String subject, MessageType type) {
            this(targetClass, subject, Long.MIN_VALUE, type);
        }

        protected Builder(Class<? extends EMessageObject> targetClass, String subject, long timestamp, MessageType type) {
            super(targetClass);
            this.mSubject = subject;
            this.mTimestamp = timestamp;
            this.mType = type;
        }

        @Override
        protected void validate(List<String> problems) {
            if (this.mSubject == null) {
                problems.add("subject not set");
            }
            if (this.mType == null) {
                problems.add("message type not set");
            }
        }

        public final B subject(String subject) {
            if (Strings.isNullOrEmpty((String)subject)) {
                throw new IllegalArgumentException("subject is null or empty");
            }
            this.mSubject = subject;
            return (B)this;
        }

        public final B timestamp(long ts) {
            this.mTimestamp = ts;
            return (B)this;
        }

        public final B timestamp(Instant ts) {
            this.mTimestamp = ts.toEpochMilli();
            return (B)this;
        }
    }

    public static enum MessageType {
        NOTIFICATION(ENotificationMessage.class),
        REQUEST(ERequestMessage.class),
        REPLY(EReplyMessage.class),
        SYSTEM(ESystemMessage.class);

        private final Class<? extends EMessage> mMsgClass;

        private MessageType(Class<? extends EMessage> mc) {
            this.mMsgClass = mc;
        }

        public Class<? extends EMessage> messageClass() {
            return this.mMsgClass;
        }

        public boolean isMatching(Class mc) {
            return mc != null && this.mMsgClass.isAssignableFrom(mc);
        }
    }
}

