/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.messages;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.sf.eBus.messages.EMessageObject;

public abstract class EAbstractList<E extends EMessageObject>
extends ArrayList<E>
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 328192L;
    protected boolean mReadOnlyFlag = false;

    protected EAbstractList() {
    }

    protected EAbstractList(int initialCapacity) {
        super(initialCapacity);
    }

    protected EAbstractList(Collection<E> c) {
        super(c);
    }

    @Override
    public void sort(Comparator<? super E> c) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        super.sort(c);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList operation is not supported");
    }

    @Override
    public Iterator<E> iterator() {
        return new EIterator(super.iterator());
    }

    @Override
    public ListIterator<E> listIterator() {
        return new EListIterator(super.listIterator());
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new EListIterator(super.listIterator(index));
    }

    @Override
    public void add(int index, E element) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        super.add(index, element);
    }

    @Override
    public boolean add(E e) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.add(e);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.addAll(c);
    }

    @Override
    public E set(int index, E element) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return (E)((EMessageObject)super.set(index, element));
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.retainAll(c);
    }

    @Override
    public void replaceAll(UnaryOperator<E> operator) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        super.replaceAll(operator);
    }

    @Override
    public boolean remove(Object o) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.remove(o);
    }

    @Override
    public E remove(int index) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return (E)((EMessageObject)super.remove(index));
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.removeAll(c);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        super.removeRange(fromIndex, toIndex);
    }

    @Override
    public boolean removeIf(Predicate<? super E> filter) {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        return super.removeIf(filter);
    }

    @Override
    public void clear() {
        if (this.mReadOnlyFlag) {
            throw new UnsupportedOperationException("list is read-only");
        }
        super.clear();
    }

    public final boolean isReadOnly() {
        return this.mReadOnlyFlag;
    }

    public final void setReadOnly() {
        this.mReadOnlyFlag = true;
    }

    private final class EListIterator<E extends EMessageObject>
    implements ListIterator<E> {
        private final ListIterator<E> mRealIterator;

        private EListIterator(ListIterator<E> lit) {
            this.mRealIterator = lit;
        }

        @Override
        public boolean hasNext() {
            return this.mRealIterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((EMessageObject)this.mRealIterator.next());
        }

        @Override
        public boolean hasPrevious() {
            return this.mRealIterator.hasPrevious();
        }

        @Override
        public E previous() {
            return (E)((EMessageObject)this.mRealIterator.previous());
        }

        @Override
        public int nextIndex() {
            return this.mRealIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.mRealIterator.previousIndex();
        }

        @Override
        public void remove() {
            if (EAbstractList.this.mReadOnlyFlag) {
                throw new UnsupportedOperationException("list is read-only");
            }
            this.mRealIterator.remove();
        }

        @Override
        public void set(E e) {
            if (EAbstractList.this.mReadOnlyFlag) {
                throw new UnsupportedOperationException("list is read-only");
            }
            this.mRealIterator.set(e);
        }

        @Override
        public void add(E e) {
            if (EAbstractList.this.mReadOnlyFlag) {
                throw new UnsupportedOperationException("list is read-only");
            }
            this.mRealIterator.add(e);
        }

        @Override
        public void forEachRemaining(Consumer<? super E> a) {
            this.mRealIterator.forEachRemaining(a);
        }
    }

    private final class EIterator<E extends EMessageObject>
    implements Iterator<E> {
        private final Iterator<E> mRealIterator;

        private EIterator(Iterator<E> it) {
            this.mRealIterator = it;
        }

        @Override
        public boolean hasNext() {
            return this.mRealIterator.hasNext();
        }

        @Override
        public E next() {
            return (E)((EMessageObject)this.mRealIterator.next());
        }

        @Override
        public void remove() {
            if (EAbstractList.this.mReadOnlyFlag) {
                throw new UnsupportedOperationException("list is read-only");
            }
            this.mRealIterator.remove();
        }

        @Override
        public void forEachRemaining(Consumer<? super E> a) {
            this.mRealIterator.forEachRemaining(a);
        }
    }
}

