/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.util.List;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.sysmessages.AbstractKeyMessage;

public final class SubscribeMessage
extends AbstractKeyMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final EFeedState feedState;

    private SubscribeMessage(Builder builder) {
        super(builder);
        this.feedState = builder.mFeedState;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof SubscribeMessage) {
            SubscribeMessage psm = (SubscribeMessage)o;
            retcode = super.equals(o) && this.feedState == psm.feedState;
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.feedState.ordinal();
    }

    @Override
    public String toString() {
        return String.format("%s%n             feed state: %s", new Object[]{super.toString(), this.feedState});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractKeyMessage.Builder<SubscribeMessage, Builder> {
        private EFeedState mFeedState;

        private Builder() {
            super(SubscribeMessage.class);
        }

        @Override
        protected SubscribeMessage buildImpl() {
            return new SubscribeMessage(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mFeedState == null) {
                problems.add("feed state is not set");
            }
        }

        public Builder feedState(EFeedState fs) {
            if (fs == null) {
                throw new NullPointerException("fs is null");
            }
            this.mFeedState = fs;
            return this;
        }
    }
}

