/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.util.List;
import net.sf.eBus.client.sysmessages.AbstractLogonMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.Optional;

public final class ResumeReply
extends AbstractLogonMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final EReplyMessage.ReplyStatus replyStatus;
    @Optional
    public final String replyReason;

    private ResumeReply(Builder builder) {
        super(builder);
        this.replyStatus = builder.mReplyStatus;
        this.replyReason = builder.mReplyReason;
    }

    @Override
    public String toString() {
        return String.format("%s%n                 status: %s%n                reason: %s", new Object[]{super.toString(), this.replyStatus, this.replyReason});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractLogonMessage.Builder<ResumeReply, Builder> {
        private EReplyMessage.ReplyStatus mReplyStatus;
        private String mReplyReason;

        private Builder() {
            super(ResumeReply.class);
        }

        @Override
        protected ResumeReply buildImpl() {
            return new ResumeReply(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mReplyStatus == null) {
                problems.add("reply status not set");
            }
        }

        public Builder replyStatus(EReplyMessage.ReplyStatus status) {
            if (status == null) {
                throw new NullPointerException("status is null");
            }
            this.mReplyStatus = status;
            return this;
        }

        public Builder replyReason(String reason) {
            this.mReplyReason = reason;
            return this;
        }
    }
}

