/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import net.sf.eBus.client.sysmessages.AbstractLogonMessage;
import net.sf.eBus.config.EConfigure;

public final class PauseRequest
extends AbstractLogonMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final Duration pauseTime;
    public final int maximumBacklogSize;
    public final EConfigure.DiscardPolicy discardPolicy;

    private PauseRequest(Builder builder) {
        super(builder);
        this.pauseTime = builder.mPauseTime;
        this.maximumBacklogSize = builder.mMaximumBacklogSize;
        this.discardPolicy = builder.mDiscardPolicy;
    }

    @Override
    public String toString() {
        return String.format("%s%n             pause time: %s%n       max backlog size: %d%n        discard policy: %s", super.toString(), this.pauseTime, this.maximumBacklogSize, this.discardPolicy);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractLogonMessage.Builder<PauseRequest, Builder> {
        private Duration mPauseTime;
        private int mMaximumBacklogSize = 0;
        private EConfigure.DiscardPolicy mDiscardPolicy = EConfigure.DiscardPolicy.OLDEST_FIRST;

        private Builder() {
            super(PauseRequest.class);
        }

        @Override
        protected PauseRequest buildImpl() {
            return new PauseRequest(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mPauseTime == null) {
                problems.add("pause time not set");
            }
        }

        public Builder pauseTime(Duration time) {
            if (time == null) {
                throw new NullPointerException("time is null");
            }
            this.mPauseTime = time;
            return this;
        }

        public Builder maximumBacklogSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("size < zero");
            }
            this.mMaximumBacklogSize = size;
            return this;
        }

        public Builder discardPolicy(EConfigure.DiscardPolicy policy) {
            if (policy == null) {
                throw new NullPointerException("policy is null");
            }
            this.mDiscardPolicy = policy;
            return this;
        }
    }
}

