/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.time.Duration;
import java.util.List;
import net.sf.eBus.client.sysmessages.AbstractLogonMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.Optional;

public final class PauseReply
extends AbstractLogonMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final EReplyMessage.ReplyStatus replyStatus;
    @Optional
    public final String replyReason;
    public final Duration pauseTime;
    public final int maximumBacklogSize;

    private PauseReply(Builder builder) {
        super(builder);
        this.replyStatus = builder.mReplyStatus;
        this.replyReason = builder.mReplyReason;
        this.pauseTime = builder.mPauseTime;
        this.maximumBacklogSize = builder.mMaximumBacklogSize;
    }

    @Override
    public String toString() {
        return String.format("%s%n                 status: %s%n                reason: %s%n             pause time: %s%n       max backlog size: %d", new Object[]{super.toString(), this.replyStatus, this.replyReason, this.pauseTime, this.maximumBacklogSize});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractLogonMessage.Builder<PauseReply, Builder> {
        private EReplyMessage.ReplyStatus mReplyStatus;
        private String mReplyReason;
        private Duration mPauseTime;
        private int mMaximumBacklogSize = 0;

        private Builder() {
            super(PauseReply.class);
        }

        @Override
        protected PauseReply buildImpl() {
            return new PauseReply(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mReplyStatus == null) {
                problems.add("reply status not set");
            }
            if (this.mPauseTime == null) {
                problems.add("pause time not set");
            }
        }

        public Builder replyStatus(EReplyMessage.ReplyStatus status) {
            if (status == null) {
                throw new NullPointerException("status is null");
            }
            this.mReplyStatus = status;
            return this;
        }

        public Builder replyReason(String reason) {
            this.mReplyReason = reason;
            return this;
        }

        public Builder pauseTime(Duration time) {
            if (time == null) {
                throw new NullPointerException("time is null");
            }
            this.mPauseTime = time;
            return this;
        }

        public Builder maximumBacklogSize(int size) {
            if (size < 0) {
                throw new IllegalArgumentException("size < zero");
            }
            this.mMaximumBacklogSize = size;
            return this;
        }
    }
}

