/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.util.List;
import net.sf.eBus.client.sysmessages.AbstractLogonMessage;
import net.sf.eBus.messages.EReplyMessage;
import net.sf.eBus.messages.Optional;

public final class LogonReply
extends AbstractLogonMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final EReplyMessage.ReplyStatus logonStatus;
    @Optional
    public final String reason;

    private LogonReply(Builder builder) {
        super(builder);
        this.logonStatus = builder.mLogonStatus;
        this.reason = builder.mReason;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof LogonReply) {
            LogonReply lr = (LogonReply)o;
            retcode = super.equals(o) && this.logonStatus == lr.logonStatus && (this.reason == null ? lr.reason == null : this.reason.equals(lr.reason));
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 37 + this.logonStatus.ordinal()) * 37 + (this.reason == null ? 0 : this.reason.hashCode());
    }

    @Override
    public String toString() {
        return String.format("%s%n           logon status: %s%n                 reason: %s", new Object[]{super.toString(), this.logonStatus, this.reason == null ? "(none)" : this.reason});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractLogonMessage.Builder<LogonReply, Builder> {
        private EReplyMessage.ReplyStatus mLogonStatus;
        private String mReason;

        private Builder() {
            super(LogonReply.class);
        }

        @Override
        protected LogonReply buildImpl() {
            return new LogonReply(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mLogonStatus == null) {
                problems.add("logon status not set");
            }
        }

        public Builder logonStatus(EReplyMessage.ReplyStatus status) {
            if (status == null) {
                throw new NullPointerException("status is null");
            }
            this.mLogonStatus = status;
            return this;
        }

        public Builder reason(String t) {
            this.mReason = t;
            return this;
        }
    }
}

