/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ESystemMessage;

public final class KeyMessage
extends ESystemMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final int keyId;
    public final String keyClass;
    public final String keySubject;

    private KeyMessage(Builder builder) {
        super(builder);
        this.keyId = builder.mKeyId;
        this.keyClass = builder.mKeyClass;
        this.keySubject = builder.mKeySubject;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof KeyMessage) {
            retcode = super.equals(o) && this.keyId == ((KeyMessage)o).keyId;
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.keyId;
    }

    @Override
    public String toString() {
        return String.format("%s%n                key ID: %d%n             class name: %s%n                subject: %s", super.toString(), this.keyId, this.keyClass, this.keySubject);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends ESystemMessage.Builder<KeyMessage, Builder> {
        private int mKeyId;
        private String mKeyClass;
        private String mKeySubject;

        private Builder() {
            super(KeyMessage.class);
        }

        @Override
        protected KeyMessage buildImpl() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mKeyClass == null) {
                problems.add("key class not set");
            }
            if (this.mKeySubject == null) {
                problems.add("key subject not set");
            }
        }

        public Builder keyId(int id) {
            this.mKeyId = id;
            return this;
        }

        public Builder keyClass(String mc) {
            if (Strings.isNullOrEmpty((String)mc)) {
                throw new IllegalArgumentException("mc is null or empty");
            }
            this.mKeyClass = mc;
            return this;
        }

        public Builder keySubject(String subject) {
            if (Strings.isNullOrEmpty((String)subject)) {
                throw new IllegalArgumentException("subject is null or empty");
            }
            this.mKeySubject = subject;
            return this;
        }

        public Builder key(EMessageKey key) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            this.mKeyClass = key.className();
            this.mKeySubject = key.subject();
            return this;
        }
    }
}

