/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import java.io.Serializable;
import java.util.List;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.sysmessages.AbstractKeyMessage;
import net.sf.eBus.messages.EMessage;

public final class AdMessage
extends AbstractKeyMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final AdStatus adStatus;
    public final EMessage.MessageType adMessageType;
    public final EFeedState feedState;

    private AdMessage(Builder builder) {
        super(builder);
        this.adStatus = builder.mAdStatus;
        this.adMessageType = builder.mMessageType;
        this.feedState = builder.mFeedState;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof AdMessage) {
            AdMessage adMsg = (AdMessage)o;
            retcode = super.equals(o) && this.adStatus == adMsg.adStatus && this.adMessageType == adMsg.adMessageType && this.feedState == adMsg.feedState;
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        return ((super.hashCode() * 37 + this.adStatus.ordinal()) * 37 + this.adMessageType.ordinal()) * 37 + this.feedState.ordinal();
    }

    @Override
    public String toString() {
        return String.format("%s%n       advertise status: %s%n           message type: %s%n             feed state: %s", new Object[]{super.toString(), this.adStatus, this.adMessageType, this.feedState});
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    extends AbstractKeyMessage.Builder<AdMessage, Builder> {
        private AdStatus mAdStatus;
        private EMessage.MessageType mMessageType;
        private EFeedState mFeedState;

        private Builder() {
            super(AdMessage.class);
        }

        @Override
        protected AdMessage buildImpl() {
            return new AdMessage(this);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mAdStatus == null) {
                problems.add("ad status not set");
            }
            if (this.mMessageType == null) {
                problems.add("message type not set");
            }
        }

        public Builder adStatus(AdStatus status) {
            if (status == null) {
                throw new NullPointerException("status is null");
            }
            this.mAdStatus = status;
            return this;
        }

        public Builder adMessageType(EMessage.MessageType mt) {
            if (mt == null) {
                throw new NullPointerException("mt is null");
            }
            this.mMessageType = mt;
            return this;
        }

        public Builder feedState(EFeedState fs) {
            this.mFeedState = fs;
            return this;
        }
    }

    public static enum AdStatus {
        ADD,
        REMOVE;

    }
}

