/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client.sysmessages;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.List;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.EMessageObject;
import net.sf.eBus.messages.ESystemMessage;
import net.sf.eBus.messages.UnknownMessageException;

public abstract class AbstractKeyMessage
extends ESystemMessage
implements Serializable {
    private static final long serialVersionUID = 328192L;
    public final String messageClass;
    public final String messageSubject;

    protected AbstractKeyMessage(Builder<?, ?> builder) {
        super((ESystemMessage.Builder<?, ?>)builder);
        this.messageClass = ((Builder)builder).mMessageClass;
        this.messageSubject = ((Builder)builder).mMessageSubject;
    }

    @Override
    public boolean equals(Object o) {
        boolean retcode;
        boolean bl = retcode = this == o;
        if (!retcode && o instanceof AbstractKeyMessage) {
            AbstractKeyMessage keyMsg = (AbstractKeyMessage)o;
            retcode = super.equals(o) && this.messageClass.equals(keyMsg.messageClass) && this.messageSubject.equals(keyMsg.messageSubject);
        }
        return retcode;
    }

    @Override
    public int hashCode() {
        return (super.hashCode() * 37 + this.messageClass.hashCode()) * 37 + this.messageSubject.hashCode();
    }

    @Override
    public String toString() {
        return String.format("%s%n            message key: %s/%s", super.toString(), this.messageClass, this.messageSubject);
    }

    public final EMessageKey messageKey() throws UnknownMessageException {
        Class<?> mc;
        try {
            mc = Class.forName(this.messageClass);
        }
        catch (ClassNotFoundException classex) {
            throw new UnknownMessageException(this.messageClass);
        }
        return new EMessageKey(mc, this.messageSubject);
    }

    public static abstract class Builder<M extends AbstractKeyMessage, B extends Builder<M, ?>>
    extends ESystemMessage.Builder<M, B> {
        private String mMessageClass;
        private String mMessageSubject;

        protected Builder(Class<? extends EMessageObject> targetClass) {
            super(targetClass);
        }

        @Override
        protected void validate(List<String> problems) {
            super.validate(problems);
            if (this.mMessageClass == null) {
                problems.add("message class not set");
            }
            if (this.mMessageSubject == null) {
                problems.add("message subject not set");
            }
        }

        public B messageClass(String mc) {
            if (Strings.isNullOrEmpty((String)mc)) {
                throw new IllegalArgumentException("mc is null or empty");
            }
            this.mMessageClass = mc;
            return (B)this;
        }

        public B messageSubject(String subject) {
            if (Strings.isNullOrEmpty((String)subject)) {
                throw new IllegalArgumentException("subject is null or empty");
            }
            this.mMessageSubject = subject;
            return (B)this;
        }

        public B messageKey(EMessageKey key) {
            if (key == null) {
                throw new NullPointerException("key is null");
            }
            this.mMessageClass = key.className();
            this.mMessageSubject = key.subject();
            return (B)this;
        }
    }
}

