/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.HashMap;
import java.util.Map;
import net.sf.eBus.client.ERemoteApp;
import net.sf.eBus.client.sysmessages.KeyMessage;
import net.sf.eBus.client.sysmessages.SystemMessageType;
import net.sf.eBus.messages.EMessage;
import net.sf.eBus.messages.EMessageHeader;
import net.sf.eBus.messages.EMessageKey;

final class MessageKeyStore {
    private final ERemoteApp _connection;
    private final Map<EMessageKey, Integer> _ids;
    private int _nextId;

    MessageKeyStore(ERemoteApp connection) {
        this._connection = connection;
        this._ids = new HashMap<EMessageKey, Integer>();
        this._nextId = 0;
    }

    synchronized int findOrCreate(EMessageKey key) {
        int retval;
        if (this._ids.containsKey(key)) {
            retval = this._ids.get(key);
        } else {
            retval = this._nextId++;
            this._ids.put(key, retval);
            this._connection.send(new EMessageHeader(SystemMessageType.KEY_UPDATE.keyId(), 0, 0, (EMessage)KeyMessage.builder().keyId(retval).key(key).build()));
        }
        return retval;
    }

    synchronized KeyMessage[] messages() {
        int size = this._ids.size();
        int index = 0;
        KeyMessage[] retval = new KeyMessage[size];
        this._ids.entrySet().forEach(entry -> {
            retval[index] = (KeyMessage)KeyMessage.builder().keyId((Integer)entry.getValue()).key((EMessageKey)entry.getKey()).build();
        });
        return retval;
    }
}

