/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eBus.client;

import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.eBus.client.EClient;
import net.sf.eBus.client.ECondition;
import net.sf.eBus.client.EFeed;
import net.sf.eBus.client.EFeedState;
import net.sf.eBus.client.ENotifyFeed;
import net.sf.eBus.client.ENotifySubject;
import net.sf.eBus.client.ESingleFeed;
import net.sf.eBus.client.ESubscriber;
import net.sf.eBus.client.FeedStatusCallback;
import net.sf.eBus.client.IESubscribeFeed;
import net.sf.eBus.client.NotifyCallback;
import net.sf.eBus.messages.EMessageKey;
import net.sf.eBus.messages.ENotificationMessage;

public final class ESubscribeFeed
extends ENotifyFeed
implements IESubscribeFeed {
    public static final String FEED_STATUS_METHOD = "feedStatus";
    private static final Logger sLogger = Logger.getLogger(ESubscribeFeed.class.getName());
    private final ECondition mCondition;
    private FeedStatusCallback<IESubscribeFeed> mStatusCallback;
    private NotifyCallback mNotifyCallback;

    private ESubscribeFeed(EClient client, EFeed.FeedScope scope, ECondition condition, ENotifySubject subject) {
        super(client, scope, ESingleFeed.FeedType.SUBSCRIBE_FEED, subject);
        this.mCondition = condition;
        this.mStatusCallback = null;
        this.mNotifyCallback = null;
    }

    @Override
    int updateActivation(EClient.ClientLocation loc, EFeedState fs) {
        boolean updateFlag = false;
        int retval = 0;
        if (this.mScope.supports(loc)) {
            if (fs == EFeedState.UP) {
                ++this.mActivationCount;
                retval = 1;
                updateFlag = this.mActivationCount == 1;
            } else if (this.mActivationCount > 0) {
                --this.mActivationCount;
                retval = -1;
                boolean bl = updateFlag = this.mActivationCount == 0;
            }
            if (updateFlag) {
                this.update(fs);
            }
        }
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s subscriber %d, feed %d: %s (%s) feed state=%s, activation count=%d (%s), update?=%b -> %d.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.key(), loc, fs, this.mActivationCount, this.mScope, updateFlag, retval}));
        }
        return retval;
    }

    @Override
    void update(EFeedState feedState) {
        if (sLogger.isLoggable(Level.FINEST)) {
            sLogger.finest(String.format("%s subscriber %d, feed %d: update feed state=%s.", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, feedState}));
        }
        this.mFeedState = feedState;
        this.mEClient.dispatch(new EFeed.StatusTask<IESubscribeFeed>(feedState, this, this.mStatusCallback));
    }

    @Override
    protected void inactivate() {
        this.unsubscribe();
    }

    @Override
    public void statusCallback(FeedStatusCallback<IESubscribeFeed> cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mStatusCallback = cb;
    }

    @Override
    public void notifyCallback(NotifyCallback cb) {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (this.mInPlace) {
            throw new IllegalStateException("subscription in place");
        }
        this.mNotifyCallback = cb;
    }

    @Override
    public void subscribe() {
        if (!this.mIsActive.get()) {
            throw new IllegalStateException("feed is inactive");
        }
        if (!this.mInPlace) {
            if (this.mStatusCallback == null) {
                if (!this.isOverridden(FEED_STATUS_METHOD, EFeedState.class, IESubscribeFeed.class)) {
                    throw new IllegalStateException("feedStatus not overridden and statusCallback not set");
                }
                this.mStatusCallback = ((ESubscriber)this.mEClient.target())::feedStatus;
            }
            if (this.mNotifyCallback == null) {
                if (!this.isOverridden("notify", ENotificationMessage.class, IESubscribeFeed.class)) {
                    throw new IllegalStateException("notify not overridden and notifyCallback not set");
                }
                if (sLogger.isLoggable(Level.FINER)) {
                    sLogger.finer(String.format("%s subscriber %d, feed %d: subscribing to %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
                }
                this.mNotifyCallback = ((ESubscriber)this.mEClient.target())::notify;
            }
            ((ENotifySubject)this.mSubject).subscribe(this);
            this.mInPlace = true;
        }
    }

    @Override
    public void unsubscribe() {
        if (this.mInPlace) {
            if (sLogger.isLoggable(Level.FINER)) {
                sLogger.finer(String.format("%s subscriber %d, feed %d: unsubscribing from %s (%s).", new Object[]{this.mEClient.location(), this.mEClient.clientId(), this.mFeedId, this.mSubject.key(), this.mScope}));
            }
            ((ENotifySubject)this.mSubject).unsubscribe(this);
            this.mInPlace = false;
            this.mActivationCount = 0;
            this.mFeedState = EFeedState.UNKNOWN;
        }
    }

    void notify(ENotificationMessage msg) {
        if (this.mInPlace) {
            this.mEClient.dispatch(new EFeed.NotifyTask(msg, this.mCondition, this, this.mNotifyCallback));
        }
    }

    public static ESubscribeFeed open(ESubscriber client, EMessageKey key, EFeed.FeedScope scope, ECondition condition) {
        if (!Objects.requireNonNull(key, "key is null").isNotification()) {
            throw new IllegalArgumentException(String.format("%s is not a notification message", key));
        }
        ESubscribeFeed.checkScopes(key, scope);
        return ESubscribeFeed.open(Objects.requireNonNull(client, "client is null"), key, Objects.requireNonNull(scope, "scope is null"), condition, EClient.ClientLocation.LOCAL, false);
    }

    static ESubscribeFeed open(ESubscriber client, EMessageKey key, EFeed.FeedScope scope, ECondition cond, EClient.ClientLocation l, boolean isMulti) {
        ECondition subCondition = cond == null ? NO_CONDITION : cond;
        EClient eClient = EClient.findOrCreateClient(client, l);
        ENotifySubject subject = ENotifySubject.findOrCreate(key);
        ESubscribeFeed retval = new ESubscribeFeed(eClient, scope, subCondition, subject);
        if (!isMulti) {
            eClient.addFeed(retval);
        }
        if (sLogger.isLoggable(Level.FINE)) {
            sLogger.fine(String.format("%s subscriber %d, feed %d: opened %s (%s).", new Object[]{eClient.location(), eClient.clientId(), retval.feedId(), key, scope}));
        }
        return retval;
    }
}

